/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Level;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class LoggerAdd
implements ModelAddOperationHandler {
    static final LoggerAdd INSTANCE = new LoggerAdd();

    LoggerAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("operation").set("remove");
        final String level = operation.require("level").asString();
        final ModelNode handlers = operation.hasDefined("handlers") ? operation.get("handlers") : new ModelNode();
        ModelNode subModel = context.getSubModel();
        subModel.get("level").set(level);
        subModel.get("handlers").set(handlers);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    String loggerName = name;
                    try {
                        LoggerService service = new LoggerService(loggerName);
                        service.setLevel(Level.parse(level));
                        target.addService(LogServices.loggerName(loggerName), (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                    try {
                        if (handlers.isDefined()) {
                            LogServices.installLoggerHandlers(target, loggerName, handlers);
                        }
                    }
                    catch (Throwable t) {
                        throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

