/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.HornetQService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.jms.JMSService;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class MessagingSubsystemAdd
implements ModelAddOperationHandler {
    private static final String DEFAULT_PATH = "messaging";
    private static final String DEFAULT_RELATIVE_TO = "jboss.server.data.dir";
    private static final ServiceName PATH_BASE = MessagingServices.JBOSS_MESSAGING.append(new String[]{"paths"});
    static final String DEFAULT_BINDINGS_DIR = "bindings";
    static final String DEFAULT_JOURNAL_DIR = "journal";
    static final String DEFAULT_LARGE_MESSSAGE_DIR = "largemessages";
    static final String DEFAULT_PAGING_DIR = "paging";
    static final MessagingSubsystemAdd INSTANCE = new MessagingSubsystemAdd();

    MessagingSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        ModelNode subModel = context.getSubModel();
        subModel.setEmptyObject();
        for (String attribute : MessagingSubsystemProviders.MESSAGING_ROOT_ATTRIBUTES) {
            if (!operation.hasDefined(attribute)) continue;
            subModel.get(attribute).set(operation.get(attribute));
        }
        subModel.get("queue");
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    HornetQService hqService = new HornetQService();
                    Configuration configuration = MessagingSubsystemAdd.transformConfig(operation);
                    ServiceBuilder serviceBuilder = serviceTarget.addService(MessagingServices.JBOSS_MESSAGING, (Service)hqService).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, hqService.getMBeanServer());
                    serviceBuilder.addDependency(MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_BINDINGS_DIR, operation.get("bindings-directory"), serviceTarget), String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_BINDINGS_DIR));
                    serviceBuilder.addDependency(MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_JOURNAL_DIR, operation.get("journal-directory"), serviceTarget), String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_JOURNAL_DIR));
                    serviceBuilder.addDependency(MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_LARGE_MESSSAGE_DIR, operation.get("large-messages-directory"), serviceTarget), String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_LARGE_MESSSAGE_DIR));
                    serviceBuilder.addDependency(MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_PAGING_DIR, operation.get("paging-directory"), serviceTarget), String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_PAGING_DIR));
                    HashSet<String> socketBindings = new HashSet<String>();
                    MessagingSubsystemAdd.processAcceptors(configuration, operation, socketBindings);
                    MessagingSubsystemAdd.processConnectors(configuration, operation, socketBindings);
                    for (String socketBinding : socketBindings) {
                        ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding});
                        serviceBuilder.addDependency(socketName, SocketBinding.class, hqService.getSocketBindingInjector(socketBinding));
                    }
                    hqService.setConfiguration(configuration);
                    serviceBuilder.install();
                    JMSService.addService(serviceTarget);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    static Configuration transformConfig(ModelNode params) {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setBackup(params.get("backup").asBoolean(false));
        if (params.has("backup-connector-ref")) {
            configuration.setBackupConnectorName(params.get("backup-connector-ref").asString());
        }
        configuration.setClustered(params.get("clustered").asBoolean(false));
        configuration.setClusterPassword(params.get("cluster-password").asString());
        configuration.setClusterUser(params.get("cluster-user").asString());
        configuration.setConnectionTTLOverride((long)params.get("connection-ttl-override").asInt(-1));
        configuration.setCreateBindingsDir(params.get("create-bindings-dir").asBoolean(true));
        configuration.setCreateJournalDir(params.get("create-journal-dir").asBoolean(true));
        configuration.setEnabledAsyncConnectionExecution(params.get("async-connection-execution-enabled").asBoolean(true));
        configuration.setIDCacheSize(params.get("id-cache-size").asInt(2000));
        if (params.hasDefined("jmx-domain")) {
            configuration.setJMXDomain(params.get("jmx-domain").asString());
        }
        configuration.setJMXManagementEnabled(params.get("jmx-management-enabled").asBoolean(true));
        JournalType journalType = params.hasDefined("journal-type") ? JournalType.valueOf((String)params.get("journal-type").asString()) : ConfigurationImpl.DEFAULT_JOURNAL_TYPE;
        configuration.setJournalType(journalType);
        configuration.setJournalBufferSize_AIO(params.get("journal-buffer-size").asInt(501760));
        configuration.setJournalBufferTimeout_AIO(params.get("journal-buffer-timeout").asInt(500000));
        configuration.setJournalMaxIO_AIO(params.get("journal-max-io").asInt(500));
        configuration.setJournalBufferSize_NIO(params.get("journal-buffer-size").asInt(501760));
        configuration.setJournalBufferTimeout_NIO(params.get("journal-buffer-timeout").asInt(3333333));
        configuration.setJournalMaxIO_NIO(params.get("journal-max-io").asInt(1));
        configuration.setJournalCompactMinFiles(params.get("journal-compact-min-files").asInt(2));
        configuration.setJournalCompactPercentage(params.get("journal-compact-percentage").asInt(30));
        configuration.setJournalFileSize(params.get("journal-file-size").asInt(0xA00000));
        configuration.setJournalMinFiles(params.get("journal-min-files").asInt(2));
        configuration.setJournalPerfBlastPages(params.get("perf-blast-pages").asInt(-1));
        configuration.setJournalSyncNonTransactional(params.get("journal-sync-non-transactional").asBoolean(true));
        configuration.setJournalSyncTransactional(params.get("journal-sync-transactional").asBoolean(true));
        configuration.setLogJournalWriteRate(params.get("log-journal-write-rate").asBoolean(false));
        configuration.setPersistDeliveryCountBeforeDelivery(params.get("persist-delivery-count-before-delivery").asBoolean(false));
        configuration.setPersistenceEnabled(params.get("persistence-enabled").asBoolean(true));
        configuration.setPersistIDCache(params.get("persist-id-cache").asBoolean(true));
        MessagingSubsystemAdd.processAddressSettings((Configuration)configuration, params);
        MessagingSubsystemAdd.processCoreQueues((Configuration)configuration, params);
        MessagingSubsystemAdd.processSecuritySettings((Configuration)configuration, params);
        return configuration;
    }

    static void processAcceptors(Configuration configuration, ModelNode params, Set<String> bindings) {
        if (params.hasDefined("acceptor")) {
            HashMap<String, TransportConfiguration> acceptors = new HashMap<String, TransportConfiguration>();
            for (Property property : params.get("acceptor").asPropertyList()) {
                String clazz;
                String acceptorName = property.getName();
                ModelNode config = property.getValue();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (config.get("param").isDefined()) {
                    for (Property parameter : config.get("param").asPropertyList()) {
                        parameters.put(parameter.getName(), parameter.getValue().asString());
                    }
                }
                MessagingServices.TransportConfigType type = MessagingServices.TransportConfigType.valueOf(config.get("type").asString());
                switch (type) {
                    case Remote: {
                        clazz = NettyAcceptorFactory.class.getName();
                        String binding = config.get("socket-binding").asString();
                        parameters.put("socket-binding", binding);
                        bindings.add(binding);
                        break;
                    }
                    case InVM: {
                        clazz = InVMAcceptorFactory.class.getName();
                        parameters.put("server-id", config.get("server-id").asInt());
                        break;
                    }
                    case Generic: {
                        clazz = config.get("factory-class").asString();
                        break;
                    }
                    default: {
                        clazz = null;
                    }
                }
                acceptors.put(acceptorName, new TransportConfiguration(clazz, parameters, acceptorName));
            }
            configuration.setAcceptorConfigurations(new HashSet(acceptors.values()));
        }
    }

    static void processConnectors(Configuration configuration, ModelNode params, Set<String> bindings) {
        if (params.hasDefined("connector")) {
            HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
            for (Property property : params.get("connector").asPropertyList()) {
                String clazz;
                String connectorName = property.getName();
                ModelNode config = property.getValue();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (config.get("param").isDefined()) {
                    for (Property parameter : config.get("param").asPropertyList()) {
                        parameters.put(parameter.getName(), parameter.getValue().asString());
                    }
                }
                MessagingServices.TransportConfigType type = MessagingServices.TransportConfigType.valueOf(config.get("type").asString());
                switch (type) {
                    case Remote: {
                        clazz = NettyConnectorFactory.class.getName();
                        String binding = config.get("socket-binding").asString();
                        parameters.put("socket-binding", binding);
                        bindings.add(binding);
                        break;
                    }
                    case InVM: {
                        clazz = InVMConnectorFactory.class.getName();
                        parameters.put("server-id", config.get("server-id").asInt());
                        break;
                    }
                    case Generic: {
                        clazz = config.get("factory-class").asString();
                        break;
                    }
                    default: {
                        clazz = null;
                    }
                }
                connectors.put(connectorName, new TransportConfiguration(clazz, parameters, connectorName));
            }
            configuration.setConnectorConfigurations(connectors);
        }
    }

    static void processCoreQueues(Configuration configuration, ModelNode params) {
        if (params.get("queue").isDefined()) {
            ArrayList<CoreQueueConfiguration> queues = new ArrayList<CoreQueueConfiguration>();
            for (Property property : params.get("queue").asPropertyList()) {
                String queueName = property.getName();
                ModelNode config = property.getValue();
                CoreQueueConfiguration queue = new CoreQueueConfiguration(config.get("address").asString(), queueName, config.get("filter").asString(), config.get("durable").asBoolean());
                queues.add(queue);
            }
            configuration.setQueueConfigurations(queues);
        }
    }

    static void processAddressSettings(Configuration configuration, ModelNode params) {
        if (params.get("address-setting").isDefined()) {
            for (Property property : params.get("address-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                AddressSettings settings = new AddressSettings();
                AddressFullMessagePolicy addressPolicy = config.hasDefined("address-full-policy") ? AddressFullMessagePolicy.valueOf((String)config.get("address-full-policy").asString()) : AddressSettings.DEFAULT_ADDRESS_FULL_MESSAGE_POLICY;
                settings.setAddressFullMessagePolicy(addressPolicy);
                settings.setDeadLetterAddress(MessagingSubsystemAdd.asSimpleString(config.get("dead-letter-address"), null));
                settings.setLastValueQueue(config.get("last-value-queue").asBoolean(false));
                settings.setMaxDeliveryAttempts(config.get("max-delivery-attempts").asInt(10));
                settings.setMaxSizeBytes((long)config.get("max-size-bytes").asInt(-1));
                settings.setMessageCounterHistoryDayLimit(config.get("message-counter-history-day-limit").asInt(0));
                settings.setExpiryAddress(MessagingSubsystemAdd.asSimpleString(config.get("expiry-address"), null));
                settings.setRedeliveryDelay((long)config.get("redelivery-delay").asInt(0));
                settings.setRedistributionDelay((long)config.get("redistribution-delay").asInt(-1));
                settings.setPageSizeBytes((long)config.get("page-size-bytes").asInt(0xA00000));
                settings.setSendToDLAOnNoRoute(config.get("send-to-dla-on-no-route").asBoolean(false));
                configuration.getAddressesSettings().put(match, settings);
            }
        }
    }

    static void processSecuritySettings(Configuration configuration, ModelNode params) {
        if (params.get("security-setting").isDefined()) {
            for (Property property : params.get("security-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                if (config.getType() == ModelType.UNDEFINED) continue;
                HashSet<Role> roles = new HashSet<Role>();
                for (Property role : config.asPropertyList()) {
                    String name = role.getName();
                    ModelNode value = role.getValue();
                    roles.add(new Role(name, value.get("send").asBoolean(false), value.get("consume").asBoolean(false), value.get("createDurableQueue").asBoolean(false), value.get("deleteDurableQueue").asBoolean(false), value.get("createNonDurableQueue").asBoolean(false), value.get("deleteNonDurableQueue").asBoolean(false), value.get("manage").asBoolean(false)));
                }
                configuration.getSecurityRoles().put(match, roles);
            }
        }
    }

    static ServiceName createDirectoryService(String name, ModelNode path, ServiceTarget serviceTarget) {
        ServiceName serviceName = PATH_BASE.append(new String[]{name});
        String relativeTo = path.hasDefined("relative-to") ? path.get("relative-to").asString() : DEFAULT_RELATIVE_TO;
        String pathName = path.hasDefined("path") ? path.get("path").asString() : DEFAULT_PATH + name;
        RelativePathService.addService((ServiceName)serviceName, (String)pathName, (String)relativeTo, (ServiceTarget)serviceTarget);
        return serviceName;
    }

    static SimpleString asSimpleString(ModelNode node, String defVal) {
        return SimpleString.toSimpleString((String)(node.getType() != ModelType.UNDEFINED ? node.asString() : defVal));
    }
}

