/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryRemove;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueRemove;
import org.jboss.as.messaging.jms.JMSSubsystemAdd;
import org.jboss.as.messaging.jms.JMSSubsystemDescribeHandler;
import org.jboss.as.messaging.jms.JMSSubsystemParser;
import org.jboss.as.messaging.jms.JMSSubsystemProviders;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicRemove;
import org.jboss.as.messaging.jms.Namespace;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JMSExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jms";
    private static final PathElement CFS_PATH = PathElement.pathElement((String)"connection-factory");
    private static final PathElement QUEUE_PATH = PathElement.pathElement((String)"queue");
    private static final PathElement TOPIC_PATH = PathElement.pathElement((String)"topic");
    private static final JMSSubsystemParser parsers = JMSSubsystemParser.getInstance();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(JMSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)JMSSubsystemAdd.INSTANCE, JMSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)JMSSubsystemDescribeHandler.INSTANCE, JMSSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parsers);
        ModelNodeRegistration cfs = registration.registerSubModel(CFS_PATH, JMSSubsystemProviders.CF);
        cfs.registerOperationHandler("add", (OperationHandler)ConnectionFactoryAdd.INSTANCE, JMSSubsystemProviders.CF_ADD, false);
        cfs.registerOperationHandler("remove", (OperationHandler)ConnectionFactoryRemove.INSTANCE, JMSSubsystemProviders.CF_REMOVE, false);
        ModelNodeRegistration queues = registration.registerSubModel(QUEUE_PATH, JMSSubsystemProviders.JMS_QUEUE);
        queues.registerOperationHandler("add", (OperationHandler)JMSQueueAdd.INSTANCE, JMSSubsystemProviders.JMS_QUEUE_ADD, false);
        queues.registerOperationHandler("remove", (OperationHandler)JMSQueueRemove.INSTANCE, JMSSubsystemProviders.JMS_QUEUE_REMOVE, false);
        ModelNodeRegistration topics = registration.registerSubModel(TOPIC_PATH, JMSSubsystemProviders.JMS_TOPIC);
        topics.registerOperationHandler("add", (OperationHandler)JMSTopicAdd.INSTANCE, JMSSubsystemProviders.JMS_TOPIC_ADD, false);
        topics.registerOperationHandler("remove", (OperationHandler)JMSTopicRemove.INSTANCE, JMSSubsystemProviders.JMS_TOPIC_REMOVE, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)parsers);
    }
}

