/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.HashSet;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class JMSQueueAdd
implements ModelAddOperationHandler {
    public static final String OPERATION_NAME = "add";
    static final JMSQueueAdd INSTANCE = new JMSQueueAdd();
    private static final String[] NO_BINDINGS = new String[0];

    JMSQueueAdd() {
    }

    static ModelNode getOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (existing.hasDefined("selector")) {
            op.get("selector").set(existing.get("selector"));
        }
        if (existing.hasDefined("durable")) {
            op.get("durable").set(existing.get("durable"));
        }
        if (existing.hasDefined("entries")) {
            op.get("entries").set(existing.get("entries"));
        }
        return op;
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        String selector;
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        ModelNode subModel = context.getSubModel();
        if (operation.hasDefined("selector")) {
            selector = operation.get("selector").asString();
            subModel.get("selector").set(selector);
        } else {
            selector = null;
        }
        if (operation.hasDefined("durable")) {
            subModel.get("durable").set(operation.get("durable"));
        }
        if (operation.hasDefined("entries")) {
            subModel.get("entries").set(operation.get("entries"));
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    JMSQueueService service = new JMSQueueService(name, selector, operation.get("durable").asBoolean(true), JMSQueueAdd.jndiBindings(operation));
                    ServiceName serviceName = JMSServices.JMS_QUEUE_BASE.append(new String[]{name});
                    context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    static String[] jndiBindings(ModelNode node) {
        if (node.hasDefined("entries")) {
            HashSet<String> bindings = new HashSet<String>();
            for (ModelNode entry : node.get("entries").asList()) {
                bindings.add(entry.asString());
            }
            return bindings.toArray(new String[bindings.size()]);
        }
        return NO_BINDINGS;
    }
}

