/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class JMSSubsystemDescribeHandler
implements ModelQueryOperationHandler {
    static final JMSSubsystemDescribeHandler INSTANCE = new JMSSubsystemDescribeHandler();

    JMSSubsystemDescribeHandler() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
        ModelNode address;
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode result = new ModelNode();
        ModelNode subModel = context.getSubModel();
        ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        result.add(subsystemAdd);
        if (subModel.hasDefined("connection-factory")) {
            for (Property property : subModel.get("connection-factory").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("connection-factory", property.getName());
                result.add(ConnectionFactoryAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("queue")) {
            for (Property property : subModel.get("queue").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("queue", property.getName());
                result.add(JMSQueueAdd.getOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("topic")) {
            for (Property property : subModel.get("topic").asPropertyList()) {
                address = rootAddress.toModelNode();
                address.add("topic", property.getName());
                result.add(JMSTopicAdd.getOperation(address, property.getValue()));
            }
        }
        resultHandler.handleResultFragment(Util.NO_LOCATION, result);
        resultHandler.handleResultComplete();
        return new BasicOperationResult();
    }
}

