/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.HashSet;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class JMSTopicAdd
implements ModelAddOperationHandler {
    public static final String OPERATION_NAME = "add";
    static final JMSTopicAdd INSTANCE = new JMSTopicAdd();
    private static final String[] NO_BINDINGS = new String[0];

    JMSTopicAdd() {
    }

    static ModelNode getOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (existing.hasDefined("entries")) {
            op.get("entries").set(existing.get("entries"));
        }
        return op;
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        if (operation.hasDefined("entries")) {
            context.getSubModel().get("entries").set(operation.get("entries"));
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    JMSTopicService service = new JMSTopicService(name, JMSTopicAdd.jndiBindings(operation));
                    ServiceName serviceName = JMSServices.JMS_TOPIC_BASE.append(new String[]{name});
                    context.getServiceTarget().addService(serviceName, (Service)service).addDependency(JMSServices.JMS_MANAGER, JMSServerManager.class, service.getJmsServer()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    static String[] jndiBindings(ModelNode node) {
        if (node.hasDefined("entries")) {
            HashSet<String> bindings = new HashSet<String>();
            for (ModelNode entry : node.get("entries").asList()) {
                bindings.add(entry.asString());
            }
            return bindings.toArray(new String[bindings.size()]);
        }
        return NO_BINDINGS;
    }
}

