/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class BroadcastGroupAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final BroadcastGroupAdd INSTANCE = new BroadcastGroupAdd();

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = Util.getOperation((String)"add", (ModelNode)address, (ModelNode)subModel);
        return operation;
    }

    private BroadcastGroupAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        for (AttributeDefinition attributeDefinition : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController hqService = registry.getService(MessagingServices.JBOSS_MESSAGING);
        if (hqService != null) {
            context.reloadRequired();
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getBroadcastGroupAdd(locale);
    }

    static void addBroadcastGroupConfigs(Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("broadcast-group")) {
            List configs = configuration.getBroadcastGroupConfigurations();
            for (Property prop : model.get("broadcast-group").asPropertyList()) {
                configs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(prop.getName(), prop.getValue()));
            }
        }
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, ModelNode model) throws OperationFailedException {
        ModelNode localAddrNode = CommonAttributes.LOCAL_BIND_ADDRESS.validateResolvedOperation(model);
        String localAddress = localAddrNode.isDefined() ? localAddrNode.asString() : null;
        int localPort = CommonAttributes.LOCAL_BIND_PORT.validateResolvedOperation(model).asInt();
        String groupAddress = CommonAttributes.GROUP_ADDRESS.validateResolvedOperation(model).asString();
        int groupPort = CommonAttributes.GROUP_ADDRESS.validateResolvedOperation(model).asInt();
        long broadcastPeriod = CommonAttributes.BROADCAST_PERIOD.validateResolvedOperation(model).asLong();
        ArrayList<String> connectorRefs = new ArrayList<String>();
        if (model.hasDefined("connectors")) {
            for (ModelNode ref : model.get("connectors").asList()) {
                connectorRefs.add(ref.asString());
            }
        }
        return new BroadcastGroupConfiguration(name, localAddress, localPort, groupAddress, groupPort, broadcastPeriod, connectorRefs);
    }
}

