/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceAdd;
import org.jboss.as.messaging.ConnectorServiceParamAdd;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class MessagingSubsystemDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    static final MessagingSubsystemDescribeHandler INSTANCE = new MessagingSubsystemDescribeHandler();

    MessagingSubsystemDescribeHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode subsystemAdd = new ModelNode();
        ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        for (AttributeDefinition attributeDefinition : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            String attrName = attributeDefinition.getName();
            if (!subModel.hasDefined(attrName)) continue;
            subsystemAdd.get(attrName).set(subModel.get(attrName));
        }
        for (String string : MessagingSubsystemProviders.MESSAGING_ROOT_ATTRIBUTES) {
            if (!subModel.hasDefined(string)) continue;
            subsystemAdd.get(string).set(subModel.get(string));
        }
        ModelNode modelNode = context.getResult();
        modelNode.add(subsystemAdd);
        if (subModel.hasDefined("broadcast-group")) {
            for (Property property : subModel.get("broadcast-group").asPropertyList()) {
                ModelNode modelNode2 = rootAddress.toModelNode();
                modelNode2.add("broadcast-group", property.getName());
                modelNode.add(BroadcastGroupAdd.getAddOperation(modelNode2, property.getValue()));
            }
        }
        if (subModel.hasDefined("discovery-group")) {
            for (Property property : subModel.get("discovery-group").asPropertyList()) {
                ModelNode modelNode3 = rootAddress.toModelNode();
                modelNode3.add("discovery-group", property.getName());
                modelNode.add(DiscoveryGroupAdd.getAddOperation(modelNode3, property.getValue()));
            }
        }
        if (subModel.hasDefined("divert")) {
            for (Property property : subModel.get("divert").asPropertyList()) {
                ModelNode modelNode4 = rootAddress.toModelNode();
                modelNode4.add("divert", property.getName());
                modelNode.add(DivertAdd.getAddOperation(modelNode4, property.getValue()));
            }
        }
        if (subModel.hasDefined("queue")) {
            for (Property property : subModel.get("queue").asPropertyList()) {
                ModelNode modelNode5 = rootAddress.toModelNode();
                modelNode5.add("queue", property.getName());
                modelNode.add(QueueAdd.getAddOperation(modelNode5, property.getValue()));
            }
        }
        if (subModel.hasDefined("bridge")) {
            for (Property property : subModel.get("bridge").asPropertyList()) {
                ModelNode modelNode6 = rootAddress.toModelNode();
                modelNode6.add("bridge", property.getName());
                modelNode.add(BridgeAdd.getAddOperation(modelNode6, property.getValue()));
            }
        }
        if (subModel.hasDefined("cluster-connection")) {
            for (Property property : subModel.get("cluster-connection").asPropertyList()) {
                ModelNode modelNode7 = rootAddress.toModelNode();
                modelNode7.add("cluster-connection", property.getName());
                modelNode.add(ClusterConnectionAdd.getAddOperation(modelNode7, property.getValue()));
            }
        }
        if (subModel.hasDefined("grouping-handler")) {
            Property property = subModel.get("grouping-handler").asProperty();
            ModelNode address2 = rootAddress.toModelNode();
            address2.add("grouping-handler", property.getName());
            modelNode.add(GroupingHandlerAdd.getAddOperation(address2, property.getValue()));
        }
        if (subModel.hasDefined("connector-service")) {
            for (Property property : subModel.get("connector-service").asPropertyList()) {
                ModelNode modelNode8 = rootAddress.toModelNode();
                modelNode8.add("connector-service", property.getName());
                ModelNode csNode = property.getValue();
                modelNode.add(ConnectorServiceAdd.getAddOperation(modelNode8, csNode));
                if (!csNode.hasDefined("param")) continue;
                for (Property param : subModel.get("param").asPropertyList()) {
                    ModelNode paramAddress = modelNode8.clone().add("param", param.getName());
                    modelNode.add(ConnectorServiceParamAdd.getAddOperation(paramAddress, property.getValue()));
                }
            }
        }
        if (subModel.hasDefined("connection-factory")) {
            for (Property property : subModel.get("connection-factory").asPropertyList()) {
                ModelNode modelNode9 = rootAddress.toModelNode();
                modelNode9.add("connection-factory", property.getName());
                modelNode.add(ConnectionFactoryAdd.getAddOperation(modelNode9, property.getValue()));
            }
        }
        if (subModel.hasDefined("pooled-connection-factory")) {
            for (Property property : subModel.get("pooled-connection-factory").asPropertyList()) {
                ModelNode modelNode10 = rootAddress.toModelNode();
                modelNode10.add("pooled-connection-factory", property.getName());
                modelNode.add(PooledConnectionFactoryAdd.getAddOperation(modelNode10, property.getValue()));
            }
        }
        if (subModel.hasDefined("jms-queue")) {
            for (Property property : subModel.get("jms-queue").asPropertyList()) {
                ModelNode modelNode11 = rootAddress.toModelNode();
                modelNode11.add("jms-queue", property.getName());
                modelNode.add(JMSQueueAdd.getOperation(modelNode11, property.getValue()));
            }
        }
        if (subModel.hasDefined("jms-topic")) {
            for (Property property : subModel.get("jms-topic").asPropertyList()) {
                ModelNode modelNode12 = rootAddress.toModelNode();
                modelNode12.add("jms-topic", property.getName());
                modelNode.add(JMSTopicAdd.getOperation(modelNode12, property.getValue()));
            }
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

