/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.deployment.BundleStartTracker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManagerService;

public class BundleInstallService
implements Service<BundleInstallService> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"osgi", "deployment"});
    private final Deployment deployment;
    private InjectedValue<BundleManagerService> injectedBundleManager = new InjectedValue();
    private InjectedValue<BundleStartTracker> injectedStartTracker = new InjectedValue();
    private ServiceName installedBundleName;

    private BundleInstallService(Deployment deployment) {
        this.deployment = deployment;
    }

    public static void addService(DeploymentPhaseContext phaseContext, Deployment deployment) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        BundleInstallService service = new BundleInstallService(deployment);
        String contextName = deploymentUnit.getName();
        ServiceName serviceName = BundleInstallService.getServiceName(contextName);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManagerService.class, service.injectedBundleManager);
        builder.addDependency(BundleStartTracker.SERVICE_NAME, BundleStartTracker.class, service.injectedStartTracker);
        builder.addDependency(Services.deploymentUnitName((String)contextName));
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_INIT);
        builder.install();
    }

    public static void removeService(DeploymentUnit context) {
        ServiceName serviceName = BundleInstallService.getServiceName(context.getName());
        ServiceController serviceController = context.getServiceRegistry().getService(serviceName);
        if (serviceController != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public static ServiceName getServiceName(String contextName) {
        ServiceName deploymentServiceName = Services.deploymentUnitName((String)contextName);
        return SERVICE_NAME_BASE.append(new String[]{deploymentServiceName.getSimpleName()});
    }

    public synchronized void start(StartContext context) throws StartException {
        log.infof("Installing deployment: %s", (Object)this.deployment);
        try {
            ServiceTarget serviceTarget = context.getChildTarget();
            BundleManagerService bundleManager = (BundleManagerService)this.injectedBundleManager.getValue();
            this.installedBundleName = bundleManager.installBundle(serviceTarget, this.deployment);
            ((BundleStartTracker)((Object)this.injectedStartTracker.getValue())).addInstalledBundle(this.installedBundleName, this.deployment);
        }
        catch (Throwable t) {
            throw new StartException("Failed to install deployment: " + this.deployment, t);
        }
    }

    public synchronized void stop(StopContext context) {
        log.infof("Uninstalling deployment: %s", (Object)this.deployment);
        try {
            BundleManagerService bundleManager = (BundleManagerService)this.injectedBundleManager.getValue();
            bundleManager.uninstallBundle(this.deployment);
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to uninstall deployment: %s", (Object)this.deployment);
        }
        ServiceName serviceName = Services.deploymentUnitName((String)context.getController().getName().getSimpleName());
        ServiceController deploymentController = context.getController().getServiceContainer().getService(serviceName);
        if (deploymentController != null) {
            deploymentController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public BundleInstallService getValue() throws IllegalStateException {
        return this;
    }

    public ServiceName getInstalledBundleName() {
        return this.installedBundleName;
    }
}

