/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import org.jboss.as.process.CliArgument;
import org.jboss.as.process.ProcessController;
import org.jboss.as.process.ProcessMessages;
import org.jboss.as.process.SynchronizedWriter;
import org.jboss.as.protocol.old.ProtocolServer;
import org.jboss.as.version.Version;
import org.jboss.logging.MDC;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.threads.JBossThreadFactory;

public final class Main {
    public static final String HOST_CONTROLLER_PROCESS_NAME = "Host Controller";
    public static final String HOST_CONTROLLER_MODULE = "org.jboss.as.host-controller";

    public static String getVersionString() {
        return Version.AS_VERSION;
    }

    public static void usage() {
        CliArgument.printUsage(System.out);
    }

    private Main() {
    }

    public static void main(String[] args) throws IOException {
        Main.start(args);
    }

    public static ProcessController start(String[] args) throws IOException {
        MDC.put((String)"process", (Object)"process controller");
        String javaHome = System.getProperty("java.home", ".");
        String jvmName = javaHome + "/bin/java";
        String jbossHome = System.getProperty("jboss.home.dir", ".");
        String modulePath = null;
        String bootJar = null;
        String logModule = "org.jboss.logmanager";
        String jaxpModule = "javax.xml.jaxp-provider";
        String bootModule = HOST_CONTROLLER_MODULE;
        String bindAddress = "127.0.0.1";
        int bindPort = 0;
        String currentWorkingDir = System.getProperty("user.dir");
        ArrayList<String> javaOptions = new ArrayList<String>();
        ArrayList<String> smOptions = new ArrayList<String>();
        block0: for (int i = 0; i < args.length; ++i) {
            String port;
            String addr;
            String arg = args[i];
            if ("-jvm".equals(arg)) {
                jvmName = args[++i];
                continue;
            }
            if ("-jboss-home".equals(arg)) {
                jbossHome = args[++i];
                continue;
            }
            if ("-mp".equals(arg)) {
                modulePath = args[++i];
                continue;
            }
            if ("-jar".equals(arg)) {
                bootJar = args[++i];
                continue;
            }
            if ("-logmodule".equals(arg)) {
                logModule = args[++i];
                continue;
            }
            if ("-jaxpmodule".equals(arg)) {
                jaxpModule = args[++i];
                continue;
            }
            if ("--bind-addr".equals(arg) || "-bind-addr".equals(arg)) {
                bindAddress = args[++i];
                continue;
            }
            if (arg.startsWith("--bind-addr")) {
                addr = Main.parseValue(arg, "--bind-addr");
                if (addr == null) {
                    return null;
                }
                bindAddress = addr;
                continue;
            }
            if (arg.startsWith("-bind-addr")) {
                addr = Main.parseValue(arg, "-bind-addr");
                if (addr == null) {
                    return null;
                }
                bindAddress = addr;
                continue;
            }
            if (arg.startsWith("--bind-port")) {
                port = Main.parseValue(arg, "--bind-port");
                if (port == null) {
                    return null;
                }
                bindPort = Integer.parseInt(port);
                continue;
            }
            if (arg.startsWith("-bind-port")) {
                port = Main.parseValue(arg, "-bind-port");
                if (port == null) {
                    return null;
                }
                bindPort = Integer.parseInt(port);
                continue;
            }
            if ("--bind-port".equals(arg) || "-bind-port".equals(arg)) {
                bindPort = Integer.parseInt(args[++i]);
                continue;
            }
            if ("--".equals(arg)) {
                ++i;
                while (i < args.length) {
                    arg = args[i];
                    if ("--".equals(arg)) {
                        ++i;
                        while (i < args.length) {
                            arg = args[i];
                            if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                                Main.usage();
                                return null;
                            }
                            if ("--version".equals(arg) || "-V".equals(arg) || "-version".equals(arg)) {
                                System.out.println("\nJBoss Application Server " + Main.getVersionString());
                                return null;
                            }
                            smOptions.add(arg);
                            ++i;
                        }
                        break block0;
                    }
                    javaOptions.add(arg);
                    ++i;
                }
                break;
            }
            throw ProcessMessages.MESSAGES.invalidOption(arg);
        }
        if (modulePath == null) {
            modulePath = System.getProperty("jboss.module.path", jbossHome + File.separator + "modules");
        }
        if (bootJar == null) {
            bootJar = jbossHome + File.separator + "jboss-modules.jar";
        }
        Handler consoleHandler = null;
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            if (consoleHandler != null) {
                rootLogger.removeHandler(handler);
                continue;
            }
            consoleHandler = handler;
            ((ConsoleHandler)consoleHandler).setWriter((Writer)new SynchronizedWriter(System.out));
        }
        ProtocolServer.Configuration configuration = new ProtocolServer.Configuration();
        if (bindAddress != null) {
            configuration.setBindAddress(new InetSocketAddress(bindAddress, bindPort));
        } else {
            configuration.setBindAddress(new InetSocketAddress(bindPort));
        }
        configuration.setBindAddress(new InetSocketAddress(InetAddress.getLocalHost(), 0));
        configuration.setSocketFactory(ServerSocketFactory.getDefault());
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("ProcessController-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        configuration.setThreadFactory((ThreadFactory)threadFactory);
        configuration.setReadExecutor((Executor)Executors.newCachedThreadPool((ThreadFactory)threadFactory));
        final ProcessController processController = new ProcessController(configuration, System.out, System.err);
        InetSocketAddress boundAddress = processController.getServer().getBoundAddress();
        ArrayList<String> initialCommand = new ArrayList<String>();
        initialCommand.add(jvmName);
        initialCommand.addAll(javaOptions);
        initialCommand.add("-jar");
        initialCommand.add(bootJar);
        initialCommand.add("-mp");
        initialCommand.add(modulePath);
        initialCommand.add("-logmodule");
        initialCommand.add(logModule);
        initialCommand.add("-jaxpmodule");
        initialCommand.add(jaxpModule);
        initialCommand.add(bootModule);
        initialCommand.add("--pc-address");
        initialCommand.add(boundAddress.getHostName());
        initialCommand.add("--pc-port");
        initialCommand.add(Integer.toString(boundAddress.getPort()));
        initialCommand.addAll(smOptions);
        initialCommand.add("-Djboss.home.dir=" + jbossHome);
        processController.addProcess(HOST_CONTROLLER_PROCESS_NAME, initialCommand, Collections.<String, String>emptyMap(), currentWorkingDir, true);
        processController.startProcess(HOST_CONTROLLER_PROCESS_NAME);
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                processController.shutdown();
            }
        }, "Shutdown thread");
        shutdownThread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        return processController;
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }
}

