/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;

public abstract class ManagementHeaderMessageHandler
extends AbstractMessageHandler {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(Connection connection, InputStream dataStream) throws IOException {
        SimpleByteDataInput input = null;
        int workingVersion = 1;
        int responseId = -1;
        try {
            input = new SimpleByteDataInput(dataStream);
            ManagementRequestHeader requestHeader = new ManagementRequestHeader(input);
            workingVersion = Math.min(1, requestHeader.getVersion());
            byte handlerId = requestHeader.getOperationHandlerId();
            if (handlerId == -1) {
                throw new IOException("Management request failed.  Invalid handler id");
            }
            MessageHandler handler = this.getHandlerForId(handlerId);
            if (handler == null) {
                String msg = "Management request failed.  No handler found for id " + handlerId;
                throw new IOException(msg);
            }
            connection.setMessageHandler(handler);
            responseId = requestHeader.getRequestId();
        }
        catch (IOException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new IOException("Failed to read request header", t);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                StreamUtils.safeClose(dataStream);
                this.writeResponseHeader(connection, workingVersion, responseId);
                throw throwable;
            }
        }
        StreamUtils.safeClose(input);
        StreamUtils.safeClose(dataStream);
        this.writeResponseHeader(connection, workingVersion, responseId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeResponseHeader(Connection connection, int version, int responseId) throws IOException {
        OutputStream dataOutput = null;
        SimpleByteDataOutput output = null;
        try {
            dataOutput = connection.writeMessage();
            output = new SimpleByteDataOutput(dataOutput);
            ManagementResponseHeader responseHeader = new ManagementResponseHeader(version, responseId);
            responseHeader.write(output);
            output.close();
            dataOutput.close();
        }
        catch (IOException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new IOException("Failed to write management response headers", t);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                StreamUtils.safeClose(dataOutput);
                throw throwable;
            }
        }
        StreamUtils.safeClose(output);
        StreamUtils.safeClose(dataOutput);
    }

    protected abstract MessageHandler getHandlerForId(byte var1);
}

