/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.remoting.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class RemotingSubsystemProviders {
    static final String RESOURCE_NAME = RemotingSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = RemotingSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("remoting"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.REMOTING_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "thread-pool", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "thread-pool", "description"}).set(bundle.getString("remoting.thread-pool"));
            subsystem.get(new String[]{"attributes", "thread-pool", "required"}).set(true);
            subsystem.get(new String[]{"children", "connector", "description"}).set(bundle.getString("remoting.connectors"));
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = RemotingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("remoting.add"));
            operation.get(new String[]{"request-properties", "thread-pool", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "thread-pool", "description"}).set(bundle.getString("remoting.thread-pool"));
            operation.get(new String[]{"request-properties", "thread-pool", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider CONNECTOR_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = RemotingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("remoting.connector.add"));
            operation.get(new String[]{"request-properties", "socket-binding", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "socket-binding", "description"}).set(bundle.getString("remoting.connector.socket-binding"));
            operation.get(new String[]{"request-properties", "socket-binding", "required"}).set(true);
            operation.get(new String[]{"request-properties", "authentication-provider", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "authentication-provider", "description"}).set(bundle.getString("remoting.connector.authentication-provider"));
            operation.get(new String[]{"request-properties", "authentication-provider", "required"}).set(false);
            operation.get(new String[]{"request-properties", "sasl"}).set(RemotingSubsystemProviders.getSaslElement(bundle, "value-type"));
            return operation;
        }
    };
    static final DescriptionProvider CONNECTOR_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = RemotingSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("remoting.connector.name"));
            operation.get(new String[]{"request-properties", "name", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider CONNECTOR_SPEC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = RemotingSubsystemProviders.getResourceBundle(locale);
            return RemotingSubsystemProviders.getConnectorDescription(bundle);
        }
    };
    static final DescriptionProvider SASL_SPEC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = RemotingSubsystemProviders.getResourceBundle(locale);
            return RemotingSubsystemProviders.getSaslElement(bundle);
        }
    };

    RemotingSubsystemProviders() {
    }

    static ModelNode getConnectorDescription(ResourceBundle bundle) {
        ModelNode connector = new ModelNode();
        connector.get("type").set(ModelType.OBJECT);
        connector.get("description").set(bundle.getString("remoting.connector"));
        connector.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        connector.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("remoting.connector.name"));
        connector.get(new String[]{"attributes", "name", "required"}).set(true);
        connector.get(new String[]{"attributes", "socket-binding", "type"}).set(ModelType.STRING);
        connector.get(new String[]{"attributes", "socket-binding", "description"}).set(bundle.getString("remoting.connector.socket-binding"));
        connector.get(new String[]{"attributes", "socket-binding", "required"}).set(true);
        connector.get(new String[]{"attributes", "authentication-provider", "type"}).set(ModelType.STRING);
        connector.get(new String[]{"attributes", "authentication-provider", "description"}).set(bundle.getString("remoting.connector.authentication-provider"));
        connector.get(new String[]{"attributes", "authentication-provider", "required"}).set(false);
        connector.get(new String[]{"children", "sasl", "description"}).set(bundle.getString("remoting.connector.sasl"));
        return connector;
    }

    private static ModelNode getSaslElement(ResourceBundle bundle) {
        return RemotingSubsystemProviders.getSaslElement(bundle, "attributes");
    }

    private static ModelNode getSaslElement(ResourceBundle bundle, String propType) {
        ModelNode sasl = new ModelNode();
        sasl.get("type").set(ModelType.OBJECT);
        sasl.get("description").set(bundle.getString("remoting.sasl"));
        sasl.get("required").set(false);
        sasl.get(new String[]{propType, "reuse-session", "type"}).set(ModelType.BOOLEAN);
        sasl.get(new String[]{propType, "reuse-session", "description"}).set(bundle.getString("remoting.sasl.reuse-session"));
        sasl.get(new String[]{propType, "reuse-session", "required"}).set(false);
        sasl.get(new String[]{propType, "reuse-session", "default"}).set(false);
        sasl.get(new String[]{propType, "server-auth", "type"}).set(ModelType.BOOLEAN);
        sasl.get(new String[]{propType, "server-auth", "description"}).set(bundle.getString("remoting.sasl.server-auth"));
        sasl.get(new String[]{propType, "server-auth", "required"}).set(false);
        sasl.get(new String[]{propType, "server-auth", "default"}).set(false);
        sasl.get(new String[]{propType, "include-mechanisms", "type"}).set(ModelType.LIST);
        sasl.get(new String[]{propType, "include-mechanisms", "value-type"}).set(ModelType.STRING);
        sasl.get(new String[]{propType, "include-mechanisms", "description"}).set(bundle.getString("remoting.sasl.include-mechanisms"));
        sasl.get(new String[]{propType, "include-mechanisms", "required"}).set(false);
        sasl.get(new String[]{propType, "qop", "type"}).set(ModelType.LIST);
        sasl.get(new String[]{propType, "qop", "value-type"}).set(ModelType.STRING);
        sasl.get(new String[]{propType, "qop", "description"}).set(bundle.getString("remoting.sasl.qop"));
        sasl.get(new String[]{propType, "qop", "required"}).set(false);
        sasl.get(new String[]{propType, "policy"}).set(RemotingSubsystemProviders.getPolicyElement(bundle));
        sasl.get(new String[]{propType, "properties", "type"}).set(ModelType.LIST);
        sasl.get(new String[]{propType, "properties", "value-type"}).set(ModelType.PROPERTY);
        return sasl;
    }

    static ModelNode getPolicyElement(ResourceBundle bundle) {
        ModelNode policy = new ModelNode();
        policy.get("type").set(ModelType.OBJECT);
        policy.get("description").set(bundle.getString("remoting.sasl.policy"));
        policy.get(new String[]{"value-type", "forward-secrecy", "type"}).set(ModelType.BOOLEAN);
        policy.get(new String[]{"value-type", "forward-secrecy", "description"}).set(bundle.getString("remoting.sasl.policy.forward-secrecy"));
        policy.get(new String[]{"value-type", "forward-secrecy", "required"}).set(false);
        policy.get(new String[]{"value-type", "no-active", "type"}).set(ModelType.BOOLEAN);
        policy.get(new String[]{"value-type", "no-active", "description"}).set(bundle.getString("remoting.sasl.policy.no-active"));
        policy.get(new String[]{"value-type", "no-active", "required"}).set(false);
        policy.get(new String[]{"value-type", "no-anonymous", "type"}).set(ModelType.BOOLEAN);
        policy.get(new String[]{"value-type", "no-anonymous", "description"}).set(bundle.getString("remoting.sasl.policy.no-anonymous"));
        policy.get(new String[]{"value-type", "no-anonymous", "required"}).set(false);
        policy.get(new String[]{"value-type", "no-dictionary", "type"}).set(ModelType.BOOLEAN);
        policy.get(new String[]{"value-type", "no-dictionary", "description"}).set(bundle.getString("remoting.sasl.policy.no-dictionary"));
        policy.get(new String[]{"value-type", "no-dictionary", "required"}).set(false);
        policy.get(new String[]{"value-type", "no-plaintext", "type"}).set(ModelType.BOOLEAN);
        policy.get(new String[]{"value-type", "no-plaintext", "description"}).set(bundle.getString("remoting.sasl.policy.no-plain-text"));
        policy.get(new String[]{"value-type", "no-plaintext", "required"}).set(false);
        policy.get(new String[]{"value-type", "pass-credentials", "type"}).set(ModelType.BOOLEAN);
        policy.get(new String[]{"value-type", "pass-credentials", "description"}).set(bundle.getString("remoting.sasl.policy.pass-credentials"));
        policy.get(new String[]{"value-type", "pass-credentials", "required"}).set(false);
        return policy;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

