/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.security.SecurityDomainAdd;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class SecurityDomainRemove
implements ModelRemoveOperationHandler {
    static final String OPERATION_NAME = "remove";
    static final SecurityDomainRemove INSTANCE = new SecurityDomainRemove();

    private SecurityDomainRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String securityDomain = address.getLastElement().getValue();
        ModelNode compensatingOperation = SecurityDomainAdd.getRecreateOperation(opAddr, context.getSubModel());
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController service = context.getServiceRegistry().getService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}));
                    if (service != null) {
                        service.setMode(ServiceController.Mode.REMOVE);
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

