/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.Element;
import org.jboss.as.security.ModulesMap;
import org.jboss.as.security.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SecuritySubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext>,
ModulesMap {
    private static final SecuritySubsystemParser INSTANCE = new SecuritySubsystemParser();

    public static SecuritySubsystemParser getInstance() {
        return INSTANCE;
    }

    private SecuritySubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        ModelNode address = subsystem.get("address");
        address.add("subsystem", "security");
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        List<ModelNode> securityDomainsUpdates = null;
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!visited.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case SECURITY_MANAGEMENT: {
                            this.parseSecurityManagement(reader, subsystem);
                            continue block9;
                        }
                        case SUBJECT_FACTORY: {
                            this.parseSubjectFactory(reader, subsystem);
                            continue block9;
                        }
                        case SECURITY_DOMAINS: {
                            securityDomainsUpdates = this.parseSecurityDomains(reader, address);
                            continue block9;
                        }
                        case SECURITY_PROPERTIES: {
                            this.parseSecurityProperties(reader, subsystem);
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(subsystem);
        if (securityDomainsUpdates != null) {
            list.addAll(securityDomainsUpdates);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (this.isNonStandard(node, "authentication-manager-class-name") || node.hasDefined("deep-copy-subject-mode") && node.get("deep-copy-subject-mode").asBoolean() || this.isNonStandard(node, "default-callback-handler-class-name") || this.isNonStandard(node, "authorization-manager-class-name") || this.isNonStandard(node, "audit-manager-class-name") || this.isNonStandard(node, "identity-trust-manager-class-name") || this.isNonStandard(node, "mapping-manager-class-name")) {
            writer.writeEmptyElement(Element.SECURITY_MANAGEMENT.getLocalName());
            if (this.isNonStandard(node, "authentication-manager-class-name")) {
                this.writeAttribute(writer, Attribute.AUTHENTICATION_MANAGER_CLASS_NAME, node.get("authentication-manager-class-name"));
            }
            if (node.hasDefined("deep-copy-subject-mode") && node.get("deep-copy-subject-mode").asBoolean()) {
                this.writeAttribute(writer, Attribute.DEEP_COPY_SUBJECT_MODE, node.get("deep-copy-subject-mode"));
            }
            if (this.isNonStandard(node, "default-callback-handler-class-name")) {
                this.writeAttribute(writer, Attribute.DEFAULT_CALLBACK_HANDLER_CLASS_NAME, node.get("default-callback-handler-class-name"));
            }
            if (this.isNonStandard(node, "authorization-manager-class-name")) {
                this.writeAttribute(writer, Attribute.AUTHORIZATION_MANAGER_CLASS_NAME, node.get("authorization-manager-class-name"));
            }
            if (this.isNonStandard(node, "audit-manager-class-name")) {
                this.writeAttribute(writer, Attribute.AUDIT_MANAGER_CLASS_NAME, node.get("audit-manager-class-name"));
            }
            if (this.isNonStandard(node, "identity-trust-manager-class-name")) {
                this.writeAttribute(writer, Attribute.IDENTITY_TRUST_MANAGER_CLASS_NAME, node.get("identity-trust-manager-class-name"));
            }
            if (this.isNonStandard(node, "mapping-manager-class-name")) {
                this.writeAttribute(writer, Attribute.MAPPING_MANAGER_CLASS_NAME, node.get("mapping-manager-class-name"));
            }
        }
        if (this.isNonStandard(node, "subject-factory-class-name")) {
            writer.writeEmptyElement(Element.SUBJECT_FACTORY.getLocalName());
            this.writeAttribute(writer, Attribute.SUBJECT_FACTORY_CLASS_NAME, node.get("subject-factory-class-name"));
        }
        if (node.hasDefined("security-domain") && node.get("security-domain").asInt() > 0) {
            writer.writeStartElement(Element.SECURITY_DOMAINS.getLocalName());
            for (Property policy : node.get("security-domain").asPropertyList()) {
                writer.writeStartElement(Element.SECURITY_DOMAIN.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), policy.getName());
                ModelNode policyDetails = policy.getValue();
                if (policyDetails.hasDefined("extends")) {
                    this.writeAttribute(writer, Attribute.EXTENDS, policyDetails.get("extends"));
                }
                if (policyDetails.hasDefined("cache-type")) {
                    this.writeAttribute(writer, Attribute.CACHE_TYPE, policyDetails.get("cache-type"));
                }
                this.writeSecurityDomainContent(writer, policyDetails);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (node.hasDefined("security-properties")) {
            writer.writeStartElement(Element.SECURITY_PROPERTIES.getLocalName());
            ModelNode properties = node.get("security-properties");
            for (Property prop : properties.asPropertyList()) {
                writer.writeEmptyElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeSecurityDomainContent(XMLExtendedStreamWriter writer, ModelNode policyDetails) throws XMLStreamException {
        HashSet keys = new HashSet(policyDetails.keys());
        keys.remove("name");
        keys.remove("extends");
        keys.remove("cache-type");
        block10: for (String key : keys) {
            Element element = Element.forName(key);
            switch (element) {
                case AUTHENTICATION: {
                    this.writeAuthentication(writer, policyDetails.get("authentication"));
                    continue block10;
                }
                case AUTHORIZATION: {
                    this.writeAuthorization(writer, policyDetails.get("authorization"));
                    continue block10;
                }
                case ACL: {
                    this.writeACL(writer, policyDetails.get("acl"));
                    continue block10;
                }
                case AUDIT: {
                    this.writeAudit(writer, policyDetails.get("audit"));
                    continue block10;
                }
                case IDENTITY_TRUST: {
                    this.writeIdentityTrust(writer, policyDetails.get("identity-trust"));
                    continue block10;
                }
                case MAPPING: {
                    this.writeMapping(writer, policyDetails.get("mapping"));
                    continue block10;
                }
                case AUTHENTICATION_JASPI: {
                    this.writeAuthenticationJaspi(writer, policyDetails.get("authentication-jaspi"));
                    continue block10;
                }
                case JSSE: {
                    this.writeJSSE(writer, policyDetails.get("jsse"));
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected field " + element.getLocalName());
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.LOGIN_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule);
            }
            writer.writeEndElement();
        }
    }

    private void writeAuthorization(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.POLICY_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule);
            }
            writer.writeEndElement();
        }
    }

    private void writeACL(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.ACL.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.ACL_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule);
            }
            writer.writeEndElement();
        }
    }

    private void writeAudit(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUDIT.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.PROVIDER_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule);
            }
            writer.writeEndElement();
        }
    }

    private void writeIdentityTrust(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.IDENTITY_TRUST.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.TRUST_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule);
            }
            writer.writeEndElement();
        }
    }

    private void writeMapping(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.MAPPING.getLocalName());
            for (ModelNode loginModule : modelNode.asList()) {
                writer.writeStartElement(Element.MAPPING_MODULE.getLocalName());
                this.writeCommonModule(writer, loginModule);
            }
            writer.writeEndElement();
        }
    }

    private void writeAuthenticationJaspi(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION_JASPI.getLocalName());
            ModelNode moduleStack = modelNode.get("login-module-stack");
            this.writeLoginModuleStack(writer, moduleStack);
            ModelNode authModule = modelNode.get("auth-module");
            this.writeAuthModule(writer, authModule);
            writer.writeEndElement();
        }
    }

    private void writeLoginModuleStack(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            List stacks = modelNode.asList();
            for (ModelNode stack : stacks) {
                writer.writeStartElement(Element.LOGIN_MODULE_STACK.getLocalName());
                List nodes = stack.asList();
                Iterator iter = nodes.iterator();
                ModelNode nameNode = (ModelNode)iter.next();
                this.writeAttribute(writer, Attribute.NAME, nameNode.require("name"));
                while (iter.hasNext()) {
                    ModelNode loginModuleNode = (ModelNode)iter.next();
                    List lms = loginModuleNode.asList();
                    for (ModelNode loginModule : lms) {
                        writer.writeStartElement(Element.LOGIN_MODULE.getLocalName());
                        this.writeCommonModule(writer, loginModule);
                    }
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeAuthModule(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            List authModulesNode = modelNode.asList();
            for (ModelNode authModule : authModulesNode) {
                writer.writeStartElement(Element.AUTH_MODULE.getLocalName());
                this.writeCommonModule(writer, authModule);
            }
        }
    }

    private void writeCommonModule(XMLExtendedStreamWriter writer, ModelNode module) throws XMLStreamException {
        String code = module.require("code").asString();
        writer.writeAttribute(Attribute.CODE.getLocalName(), code);
        if (module.hasDefined("flag")) {
            this.writeAttribute(writer, Attribute.FLAG, module.get("flag"));
        }
        if (module.hasDefined("type")) {
            this.writeAttribute(writer, Attribute.TYPE, module.get("type"));
        }
        if (module.hasDefined("login-module-stack-ref")) {
            this.writeAttribute(writer, Attribute.LOGIN_MODULE_STACK_REF, module.get("login-module-stack-ref"));
        }
        if (module.hasDefined("module-options") && module.get("module-options").asInt() > 0) {
            this.writeModuleOptions(writer, module.get("module-options"));
        }
        writer.writeEndElement();
    }

    private void writeModuleOptions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        for (Property prop : modelNode.asPropertyList()) {
            writer.writeEmptyElement(Element.MODULE_OPTION.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
            writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
        }
    }

    private void writeJSSE(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.JSSE.getLocalName());
            if (modelNode.hasDefined("keystore-password")) {
                this.writeAttribute(writer, Attribute.KEYSTORE_PASSWORD, modelNode.get("keystore-password"));
            }
            if (modelNode.hasDefined("keystore-url")) {
                this.writeAttribute(writer, Attribute.KEYSTORE_URL, modelNode.get("keystore-url"));
            }
            if (modelNode.hasDefined("keystore-type")) {
                this.writeAttribute(writer, Attribute.KEYSTORE_TYPE, modelNode.get("keystore-type"));
            }
            if (modelNode.hasDefined("keystore-provider")) {
                this.writeAttribute(writer, Attribute.KEYSTORE_PROVIDER, modelNode.get("keystore-provider"));
            }
            if (modelNode.hasDefined("keystore-provider-argument")) {
                this.writeAttribute(writer, Attribute.KEYSTORE_PROVIDER_ARGUMENT, modelNode.get("keystore-provider-argument"));
            }
            if (modelNode.hasDefined("key-manager-factory-provider")) {
                this.writeAttribute(writer, Attribute.KEY_MANAGER_FACTORY_PROVIDER, modelNode.get("key-manager-factory-provider"));
            }
            if (modelNode.hasDefined("key-manager-factory-algorithm")) {
                this.writeAttribute(writer, Attribute.KEY_MANAGER_FACTORY_ALGORITHM, modelNode.get("key-manager-factory-algorithm"));
            }
            if (modelNode.hasDefined("truststore-password")) {
                this.writeAttribute(writer, Attribute.TRUSTSTORE_PASSWORD, modelNode.get("truststore-password"));
            }
            if (modelNode.hasDefined("truststore-url")) {
                this.writeAttribute(writer, Attribute.TRUSTSTORE_URL, modelNode.get("truststore-url"));
            }
            if (modelNode.hasDefined("truststore-type")) {
                this.writeAttribute(writer, Attribute.TRUSTSTORE_TYPE, modelNode.get("truststore-type"));
            }
            if (modelNode.hasDefined("truststore-provider")) {
                this.writeAttribute(writer, Attribute.TRUSTSTORE_PROVIDER, modelNode.get("truststore-provider"));
            }
            if (modelNode.hasDefined("truststore-provider-argument")) {
                this.writeAttribute(writer, Attribute.TRUSTSTORE_PROVIDER_ARGUMENT, modelNode.get("truststore-provider-argument"));
            }
            if (modelNode.hasDefined("trust-manager-factory-provider")) {
                this.writeAttribute(writer, Attribute.TRUST_MANAGER_FACTORY_PROVIDER, modelNode.get("trust-manager-factory-provider"));
            }
            if (modelNode.hasDefined("trust-manager-factory-algorithm")) {
                this.writeAttribute(writer, Attribute.TRUST_MANAGER_FACTORY_ALGORITHM, modelNode.get("trust-manager-factory-algorithm"));
            }
            if (modelNode.hasDefined("client-alias")) {
                this.writeAttribute(writer, Attribute.CLIENT_ALIAS, modelNode.get("client-alias"));
            }
            if (modelNode.hasDefined("server-alias")) {
                this.writeAttribute(writer, Attribute.SERVER_ALIAS, modelNode.get("server-alias"));
            }
            if (modelNode.hasDefined("client-auth")) {
                this.writeAttribute(writer, Attribute.CLIENT_AUTH, modelNode.get("client-auth"));
            }
            if (modelNode.hasDefined("service-auth-token")) {
                this.writeAttribute(writer, Attribute.SERVICE_AUTH_TOKEN, modelNode.get("service-auth-token"));
            }
            if (modelNode.hasDefined("cipher-suites")) {
                this.writeAttribute(writer, Attribute.CIPHER_SUITES, modelNode.get("cipher-suites"));
            }
            if (modelNode.hasDefined("protocols")) {
                this.writeAttribute(writer, Attribute.PROTOCOLS, modelNode.get("protocols"));
            }
            if (modelNode.hasDefined("additional-properties")) {
                writer.writeStartElement(Element.ADDITIONAL_PROPERTIES.getLocalName());
                writer.writeCharacters(modelNode.get("additional-properties").asString());
            }
            writer.writeEndElement();
        }
    }

    private boolean isNonStandard(ModelNode node, String attribute) {
        return node.hasDefined(attribute) && !"default".equals(node.get(attribute).asString());
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    private void parseSecurityManagement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        String authenticationManagerClassName = null;
        boolean deepCopySubjectMode = false;
        String defaultCallbackHandlerClassName = null;
        String authorizationManagerClassName = null;
        String auditManagerClassName = null;
        String identityTrustManagerClassName = null;
        String mappingManagerClassName = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTHENTICATION_MANAGER_CLASS_NAME: {
                    authenticationManagerClassName = value;
                    continue block9;
                }
                case DEEP_COPY_SUBJECT_MODE: {
                    deepCopySubjectMode = Boolean.parseBoolean(value);
                    continue block9;
                }
                case DEFAULT_CALLBACK_HANDLER_CLASS_NAME: {
                    defaultCallbackHandlerClassName = value;
                    continue block9;
                }
                case AUTHORIZATION_MANAGER_CLASS_NAME: {
                    authorizationManagerClassName = value;
                    continue block9;
                }
                case AUDIT_MANAGER_CLASS_NAME: {
                    auditManagerClassName = value;
                    continue block9;
                }
                case IDENTITY_TRUST_MANAGER_CLASS_NAME: {
                    identityTrustManagerClassName = value;
                    continue block9;
                }
                case MAPPING_MANAGER_CLASS_NAME: {
                    mappingManagerClassName = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (authenticationManagerClassName != null) {
            operation.get("authentication-manager-class-name").set(authenticationManagerClassName);
        }
        if (defaultCallbackHandlerClassName != null) {
            operation.get("default-callback-handler-class-name").set(defaultCallbackHandlerClassName);
        }
        if (deepCopySubjectMode) {
            operation.get("deep-copy-subject-mode").set(deepCopySubjectMode);
        }
        if (authorizationManagerClassName != null) {
            operation.get("authorization-manager-class-name").set(authorizationManagerClassName);
        }
        if (auditManagerClassName != null) {
            operation.get("audit-manager-class-name").set(auditManagerClassName);
        }
        if (identityTrustManagerClassName != null) {
            operation.get("identity-trust-manager-class-name").set(identityTrustManagerClassName);
        }
        if (mappingManagerClassName != null) {
            operation.get("mapping-manager-class-name").set(mappingManagerClassName);
        }
    }

    private void parseSubjectFactory(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        String subjectFactoryClassName = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SUBJECT_FACTORY_CLASS_NAME: {
                    subjectFactoryClassName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (subjectFactoryClassName != null) {
            operation.get("subject-factory-class-name").set(subjectFactoryClassName);
        }
    }

    private void parseSecurityProperties(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PROPERTY: {
                            this.parseModuleOption(reader, operation.get("security-properties"));
                        }
                    }
                }
            }
        }
    }

    private List<ModelNode> parseSecurityDomains(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SECURITY_DOMAIN: {
                            list.add(this.parseSecurityDomain(reader, parentAddress));
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return list;
    }

    private ModelNode parseSecurityDomain(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        ModelNode address = op.get("address");
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    address.set(parentAddress).add("security-domain", value);
                    continue block18;
                }
                case EXTENDS: {
                    op.get("extends").set(value);
                    continue block18;
                }
                case CACHE_TYPE: {
                    op.get("cache-type").set(value);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!visited.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case AUTHENTICATION: {
                            if (visited.contains((Object)Element.AUTHENTICATION_JASPI)) {
                                throw new XMLStreamException("A security domain can have either an <authentication> or <authentication-jaspi> element, not both", reader.getLocation());
                            }
                            this.parseAuthentication(reader, op.get("authentication"), true);
                            continue block19;
                        }
                        case AUTHORIZATION: {
                            this.parseAuthorization(reader, op.get("authorization"));
                            continue block19;
                        }
                        case ACL: {
                            this.parseACL(reader, op.get("acl"));
                            continue block19;
                        }
                        case AUDIT: {
                            this.parseAudit(reader, op.get("audit"));
                            continue block19;
                        }
                        case IDENTITY_TRUST: {
                            this.parseIdentityTrust(reader, op.get("identity-trust"));
                            continue block19;
                        }
                        case MAPPING: {
                            this.parseMapping(reader, op.get("mapping"));
                            continue block19;
                        }
                        case AUTHENTICATION_JASPI: {
                            if (visited.contains((Object)Element.AUTHENTICATION)) {
                                throw new XMLStreamException("A security domain can have either an <authentication> or <authentication-jaspi> element, not both", reader.getLocation());
                            }
                            this.parseAuthenticationJaspi(reader, op.get("authentication-jaspi"));
                            continue block19;
                        }
                        case JSSE: {
                            this.parseJSSE(reader, op.get("jsse"));
                            continue block19;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return op;
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, ModelNode op, boolean requireNoAttributes) throws XMLStreamException {
        if (requireNoAttributes) {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        }
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LOGIN_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthorization(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case POLICY_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseACL(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ACL_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAudit(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PROVIDER_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE, Attribute.FLAG);
                            this.parseCommonModule(reader, op.add(), required, notAllowed);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentityTrust(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case TRUST_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE, Attribute.FLAG);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.TYPE);
                            this.parseCommonModule(reader, op.add(), required, notAllowed);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseMapping(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MAPPING_MODULE: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
                            EnumSet<Attribute> notAllowed = EnumSet.of(Attribute.FLAG);
                            this.parseCommonModule(reader, op.add(), required, notAllowed);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCommonModule(XMLExtendedStreamReader reader, ModelNode node, EnumSet<Attribute> required, EnumSet<Attribute> notAllowed) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            if (notAllowed.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            required.remove((Object)attribute);
            switch (attribute) {
                case CODE: {
                    String code = value;
                    node.get("code").set(code);
                    continue block11;
                }
                case FLAG: {
                    this.validateFlag(value, reader, i);
                    node.get("flag").set(value);
                    continue block11;
                }
                case TYPE: {
                    this.validateType(value, reader, i);
                    node.get("type").set(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MODULE_OPTION: {
                            this.parseModuleOption(reader, node.get("module-options"));
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthenticationJaspi(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LOGIN_MODULE_STACK: {
                            ModelNode node = op.get("login-module-stack");
                            this.parseLoginModuleStack(reader, node.add());
                            continue block7;
                        }
                        case AUTH_MODULE: {
                            ModelNode node = op.get("auth-module");
                            this.parseAuthModule(reader, node.add());
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLoginModuleStack(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    op.add().get("name").set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        this.parseAuthentication(reader, op.add(), false);
    }

    private void parseAuthModule(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CODE);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CODE: {
                    op.get("code").set(value);
                    continue block10;
                }
                case LOGIN_MODULE_STACK_REF: {
                    op.get("login-module-stack-ref").set(value);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case MODULE_OPTION: {
                            this.parseModuleOption(reader, op.get("module-options"));
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void validateFlag(String flag, XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        if (!(flag.equals("required") || flag.equals("requisite") || flag.equals("sufficient") || flag.equals("optional"))) {
            throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
        }
    }

    private void validateType(String type, XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        if (!(type.equals("attribute") || type.equals("credential") || type.equals("principal") || type.equals("role"))) {
            throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
        }
    }

    private void parseModuleOption(XMLExtendedStreamReader reader, ModelNode moduleOptions) throws XMLStreamException {
        String name = null;
        String val = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case VALUE: {
                    val = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        moduleOptions.add(name, val);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJSSE(XMLExtendedStreamReader reader, ModelNode op) throws XMLStreamException {
        EnumSet<Attribute> visited = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        block28: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEYSTORE_PASSWORD: {
                    op.get("keystore-password").set(value);
                    visited.add(attribute);
                    continue block28;
                }
                case KEYSTORE_TYPE: {
                    op.get("keystore-type").set(value);
                    continue block28;
                }
                case KEYSTORE_URL: {
                    op.get("keystore-url").set(value);
                    continue block28;
                }
                case KEYSTORE_PROVIDER: {
                    op.get("keystore-provider").set(value);
                    continue block28;
                }
                case KEYSTORE_PROVIDER_ARGUMENT: {
                    op.get("keystore-provider-argument").set(value);
                    continue block28;
                }
                case KEY_MANAGER_FACTORY_PROVIDER: {
                    op.get("key-manager-factory-provider").set(value);
                    continue block28;
                }
                case KEY_MANAGER_FACTORY_ALGORITHM: {
                    op.get("key-manager-factory-algorithm").set(value);
                    continue block28;
                }
                case TRUSTSTORE_PASSWORD: {
                    op.get("truststore-password").set(value);
                    visited.add(attribute);
                    continue block28;
                }
                case TRUSTSTORE_TYPE: {
                    op.get("truststore-type").set(value);
                    continue block28;
                }
                case TRUSTSTORE_URL: {
                    op.get("truststore-url").set(value);
                    continue block28;
                }
                case TRUSTSTORE_PROVIDER: {
                    op.get("truststore-provider").set(value);
                    continue block28;
                }
                case TRUSTSTORE_PROVIDER_ARGUMENT: {
                    op.get("truststore-provider-argument").set(value);
                    continue block28;
                }
                case TRUST_MANAGER_FACTORY_PROVIDER: {
                    op.get("trust-manager-factory-provider").set(value);
                    continue block28;
                }
                case TRUST_MANAGER_FACTORY_ALGORITHM: {
                    op.get("trust-manager-factory-algorithm").set(value);
                    continue block28;
                }
                case CLIENT_ALIAS: {
                    op.get("client-alias").set(value);
                    continue block28;
                }
                case SERVER_ALIAS: {
                    op.get("server-alias").set(value);
                    continue block28;
                }
                case CLIENT_AUTH: {
                    op.get("client-auth").set(value);
                    continue block28;
                }
                case SERVICE_AUTH_TOKEN: {
                    op.get("service-auth-token").set(value);
                    continue block28;
                }
                case CIPHER_SUITES: {
                    op.get("cipher-suites").set(value);
                    continue block28;
                }
                case PROTOCOLS: {
                    op.get("protocols").set(value);
                    continue block28;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (visited.size() == 0) {
            throw new XMLStreamException("Missing required attribute: either " + Attribute.KEYSTORE_PASSWORD.getLocalName() + " or " + Attribute.TRUSTSTORE_PASSWORD.getLocalName() + " must be present", reader.getLocation());
        }
        block29: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case SECURITY_1_0: {
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ADDITIONAL_PROPERTIES: {
                            op.get("additional-properties").set(reader.getElementText().trim());
                            continue block29;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

