/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import javax.security.auth.login.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.SecurityLogger;
import org.jboss.as.security.SecurityMessages;
import org.jboss.as.security.plugins.DefaultAuthenticationCacheFactory;
import org.jboss.as.security.plugins.JNDIBasedSecurityManagement;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;

public class SecurityDomainService
implements Service<SecurityDomainContext> {
    public static final ServiceName SERVICE_NAME = SecurityExtension.JBOSS_SECURITY.append(new String[]{"security-domain"});
    private static final SecurityLogger log = SecurityLogger.ROOT_LOGGER;
    private final InjectedValue<ISecurityManagement> securityManagementValue = new InjectedValue();
    private final InjectedValue<Configuration> configurationValue = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> cacheManagerValue = new InjectedValue();
    private final String name;
    private final ApplicationPolicy applicationPolicy;
    private final JSSESecurityDomain jsseSecurityDomain;
    private volatile SecurityDomainContext securityDomainContext;
    private final String cacheType;

    public SecurityDomainService(String name, ApplicationPolicy applicationPolicy, JSSESecurityDomain jsseSecurityDomain, String cacheType) {
        this.name = name;
        this.applicationPolicy = applicationPolicy;
        this.jsseSecurityDomain = jsseSecurityDomain;
        this.cacheType = cacheType;
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting SecurityDomainService(" + this.name + ")", new Object[0]);
        if (this.applicationPolicy != null) {
            ApplicationPolicyRegistration applicationPolicyRegistration = (ApplicationPolicyRegistration)this.configurationValue.getValue();
            applicationPolicyRegistration.addApplicationPolicy(this.applicationPolicy.getName(), this.applicationPolicy);
        }
        JNDIBasedSecurityManagement securityManagement = (JNDIBasedSecurityManagement)this.securityManagementValue.getValue();
        Object cacheFactory = null;
        if ("infinispan".equals(this.cacheType)) {
            cacheFactory = this.cacheManagerValue.getValue();
        } else if ("default".equals(this.cacheType)) {
            cacheFactory = new DefaultAuthenticationCacheFactory();
        }
        try {
            this.securityDomainContext = securityManagement.createSecurityDomainContext(this.name, cacheFactory);
        }
        catch (Exception e) {
            throw SecurityMessages.MESSAGES.unableToStartException("SecurityDomainService", e);
        }
        if (this.jsseSecurityDomain != null) {
            try {
                this.jsseSecurityDomain.reloadKeyAndTrustStore();
                this.securityDomainContext.setJSSE(this.jsseSecurityDomain);
            }
            catch (Exception e) {
                throw SecurityMessages.MESSAGES.unableToStartException("SecurityDomainService", e);
            }
        }
        securityManagement.getSecurityManagerMap().put(this.name, this.securityDomainContext);
    }

    public void stop(StopContext context) {
        JNDIBasedSecurityManagement securityManagement = (JNDIBasedSecurityManagement)this.securityManagementValue.getValue();
        securityManagement.removeSecurityDomain(this.name);
        ApplicationPolicyRegistration applicationPolicyRegistration = (ApplicationPolicyRegistration)this.configurationValue.getValue();
        applicationPolicyRegistration.removeApplicationPolicy(this.name);
    }

    public SecurityDomainContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityDomainContext;
    }

    public Injector<ISecurityManagement> getSecurityManagementInjector() {
        return this.securityManagementValue;
    }

    public Injector<Configuration> getConfigurationInjector() {
        return this.configurationValue;
    }

    public Injector<EmbeddedCacheManager> getCacheManagerInjector() {
        return this.cacheManagerValue;
    }
}

