/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerControllerService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.deployment.impl.ContentRepositoryImpl;
import org.jboss.as.server.deployment.impl.ServerDeploymentRepositoryImpl;
import org.jboss.as.server.mgmt.ShutdownHandler;
import org.jboss.as.server.mgmt.ShutdownHandlerImpl;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ModuleIndexService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.server.services.path.AbsolutePathService;
import org.jboss.as.version.Version;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossExecutors;

final class ApplicationServerService
implements Service<AsyncFuture<ServiceContainer>> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as");
    private static final Logger configLog = Logger.getLogger((String)"org.jboss.as.config");
    private final List<ServiceActivator> extraServices;
    private final Bootstrap.Configuration configuration;
    private volatile FutureServiceContainer futureContainer;
    private volatile long startTime;

    ApplicationServerService(List<ServiceActivator> extraServices, Bootstrap.Configuration configuration) {
        this.extraServices = extraServices;
        this.configuration = configuration;
        this.startTime = configuration.getStartTime();
    }

    public synchronized void start(StartContext context) throws StartException {
        Bootstrap.Configuration configuration = this.configuration;
        ServerEnvironment serverEnvironment = configuration.getServerEnvironment();
        serverEnvironment.install();
        log.infof("JBoss AS %s \"%s\" starting", (Object)Version.AS_VERSION, (Object)Version.AS_RELEASE_CODENAME);
        if (configLog.isDebugEnabled()) {
            Properties properties = System.getProperties();
            StringBuilder b = new StringBuilder(8192);
            b.append("Configured system properties:");
            for (String property : new TreeSet<String>(properties.stringPropertyNames())) {
                b.append("\n\t").append(property).append(" = ").append(properties.getProperty(property, "<undefined>"));
            }
            configLog.debug((Object)b);
            if (configLog.isTraceEnabled()) {
                b.setLength(0);
                Map<String, String> env = System.getenv();
                b.append("Configured system environment:");
                for (String key : new TreeSet<String>(env.keySet())) {
                    b.append("\n\t").append(key).append(" = ").append(env.get(key));
                }
                configLog.trace((Object)b);
            }
        }
        final ServiceTarget serviceTarget = context.getChildTarget();
        ServiceController myController = context.getController();
        final ServiceContainer container = myController.getServiceContainer();
        this.futureContainer = new FutureServiceContainer(container);
        long startTime = this.startTime;
        if (startTime == -1L) {
            startTime = System.currentTimeMillis();
        } else {
            this.startTime = -1L;
        }
        BootstrapListener bootstrapListener = new BootstrapListener(container, startTime, serviceTarget, this.futureContainer, configuration);
        serviceTarget.addListener((ServiceListener)bootstrapListener);
        myController.addListener((ServiceListener)bootstrapListener);
        ContentRepositoryImpl contentRepository = ContentRepositoryImpl.addService((ServiceTarget)serviceTarget, (File)serverEnvironment.getServerDeployDir());
        ServerDeploymentRepositoryImpl.addService((ServiceTarget)serviceTarget, (File)serverEnvironment.getServerDeployDir(), (File)serverEnvironment.getServerSystemDeployDir(), (ContentRepositoryImpl)contentRepository);
        ServiceModuleLoader.addService(serviceTarget, configuration);
        ExternalModuleService.addService(serviceTarget);
        ModuleIndexService.addService(serviceTarget);
        ServerControllerService.addService(serviceTarget, configuration);
        ServiceActivatorContext serviceActivatorContext = new ServiceActivatorContext(){

            public ServiceTarget getServiceTarget() {
                return serviceTarget;
            }

            public ServiceRegistry getServiceRegistry() {
                return container;
            }
        };
        for (ServiceActivator activator : this.extraServices) {
            activator.activate(serviceActivatorContext);
        }
        serviceTarget.addService(ShutdownHandler.SERVICE_NAME, (Service)new ShutdownHandlerImpl()).install();
        ServerEnvironmentService.addService(serverEnvironment, serviceTarget);
        AbsolutePathService.addService("jboss.home.dir", serverEnvironment.getHomeDir().getAbsolutePath(), serviceTarget);
        AbsolutePathService.addService("jboss.server.base.dir", serverEnvironment.getServerBaseDir().getAbsolutePath(), serviceTarget);
        AbsolutePathService.addService("jboss.server.config.dir", serverEnvironment.getServerConfigurationDir().getAbsolutePath(), serviceTarget);
        AbsolutePathService.addService("jboss.server.data.dir", serverEnvironment.getServerDataDir().getAbsolutePath(), serviceTarget);
        AbsolutePathService.addService("jboss.server.log.dir", serverEnvironment.getServerLogDir().getAbsolutePath(), serviceTarget);
        AbsolutePathService.addService("jboss.server.temp.dir", serverEnvironment.getServerTempDir().getAbsolutePath(), serviceTarget);
        AbsolutePathService.addService("user.dir", System.getProperty("user.dir"), serviceTarget);
        AbsolutePathService.addService("user.home", System.getProperty("user.home"), serviceTarget);
        AbsolutePathService.addService("java.home", System.getProperty("java.home"), serviceTarget);
        if (log.isDebugEnabled()) {
            long nanos = context.getElapsedTime();
            log.debugf("JBoss AS root service started in %d.%06d ms", (Object)(nanos / 1000000L), (Object)(nanos % 1000000L));
        }
    }

    public synchronized void stop(StopContext context) {
        log.infof("JBoss AS %s \"%s\" stopped in %dms", (Object)Version.AS_VERSION, (Object)Version.AS_RELEASE_CODENAME, (Object)((int)(context.getElapsedTime() / 1000000L)));
    }

    public AsyncFuture<ServiceContainer> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.futureContainer;
    }

    private static class FutureServiceContainer
    extends AsyncFutureTask<ServiceContainer> {
        public FutureServiceContainer(ServiceContainer container) {
            super((Executor)JBossExecutors.directExecutor());
        }

        void done(ServiceContainer container) {
            this.setResult(container);
        }
    }

    private static class BootstrapListener
    extends org.jboss.as.controller.BootstrapListener {
        final FutureServiceContainer futureContainer;
        final Bootstrap.Configuration configuration;

        public BootstrapListener(ServiceContainer serviceContainer, long startTime, ServiceTarget serviceTarget, FutureServiceContainer futureContainer, Bootstrap.Configuration configuration) {
            super(serviceContainer, startTime, serviceTarget);
            this.futureContainer = futureContainer;
            this.configuration = configuration;
        }

        protected void done(ServiceContainer container, long elapsedTime, int started, int failed, EnumMap<ServiceController.Mode, AtomicInteger> map, Set<ServiceName> missingDepsSet) {
            this.futureContainer.done(container);
            Logger log = Logger.getLogger((String)"org.jboss.as");
            int active = map.get(ServiceController.Mode.ACTIVE).get();
            int passive = map.get(ServiceController.Mode.PASSIVE).get();
            int onDemand = map.get(ServiceController.Mode.ON_DEMAND).get();
            int never = map.get(ServiceController.Mode.NEVER).get();
            if (failed == 0) {
                log.infof("JBoss AS %s \"%s\" started in %dms - Started %d of %d services (%d services are passive or on-demand)", new Object[]{Version.AS_VERSION, Version.AS_RELEASE_CODENAME, elapsedTime, started, active + passive + onDemand + never, onDemand + passive});
                try {
                    this.configuration.getConfigurationPersister().successfulBoot();
                }
                catch (ConfigurationPersistenceException e) {
                    log.error((Object)e);
                }
            } else {
                log.errorf("JBoss AS %s \"%s\" started (with errors) in %dms - Started %d of %d services (%d services failed or missing dependencies, %d services are passive or on-demand)", new Object[]{Version.AS_VERSION, Version.AS_RELEASE_CODENAME, elapsedTime, started, active + passive + onDemand + never, failed, onDemand + passive});
            }
        }
    }
}

