/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.ServerTask;
import org.jboss.as.server.Services;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.as.server.mgmt.domain.HostControllerServerClient;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.BridgeRepositorySelector;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.jboss.threads.AsyncFuture;

public final class DomainServerMain {
    private DomainServerMain() {
    }

    public static void main(String[] args) {
        AsyncFuture<ServiceContainer> containerFuture;
        System.setProperty("log4j.defaultInitOverride", "true");
        new BridgeRepositorySelector().start();
        InputStream initialInput = System.in;
        PrintStream initialError = System.err;
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        byte[] authKey = new byte[16];
        try {
            StreamUtils.readFully((InputStream)initialInput, (byte[])authKey);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            throw new IllegalStateException();
        }
        MarshallerFactory factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)DomainServerMain.class.getClassLoader());
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            MarshallingConfiguration configuration = new MarshallingConfiguration();
            configuration.setVersion(2);
            configuration.setClassResolver((ClassResolver)new SimpleClassResolver(DomainServerMain.class.getClassLoader()));
            Unmarshaller unmarshaller = factory.createUnmarshaller(configuration);
            ByteInput byteInput = Marshalling.createByteInput((InputStream)initialInput);
            unmarshaller.start(byteInput);
            ServerTask task = (ServerTask)unmarshaller.readObject(ServerTask.class);
            unmarshaller.finish();
            containerFuture = task.run(Arrays.asList(new ServiceActivator(){

                public void activate(ServiceActivatorContext serviceActivatorContext) {
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace(initialError);
            System.exit(1);
            throw new IllegalStateException();
        }
        while (true) {
            try {
                while (true) {
                    String hostName = StreamUtils.readUTFZBytes((InputStream)initialInput);
                    int port = StreamUtils.readInt((InputStream)initialInput);
                    CountDownLatch latch = new CountDownLatch(2);
                    UninstallListener connectionListener = new UninstallListener(latch, HostControllerConnectionService.SERVICE_NAME);
                    UninstallListener clientListener = new UninstallListener(latch, HostControllerServerClient.SERVICE_NAME);
                    ServiceContainer container = (ServiceContainer)containerFuture.get();
                    ServiceController client = container.getRequiredService(HostControllerServerClient.SERVICE_NAME);
                    String name = ((HostControllerServerClient)client.getValue()).getServerName();
                    client.addListener((ServiceListener)clientListener);
                    client.setMode(ServiceController.Mode.REMOVE);
                    ServiceController connection = container.getRequiredService(HostControllerConnectionService.SERVICE_NAME);
                    connection.addListener((ServiceListener)connectionListener);
                    connection.setMode(ServiceController.Mode.REMOVE);
                    latch.await();
                    client.removeListener((ServiceListener)clientListener);
                    connection.removeListener((ServiceListener)connectionListener);
                    DomainServerMain.addCommunicationServices((ServiceTarget)container, name, new InetSocketAddress(InetAddress.getByName(hostName), port));
                }
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                continue;
            }
            catch (EOFException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        System.exit(0);
        throw new IllegalStateException();
    }

    private static void addCommunicationServices(ServiceTarget serviceTarget, String serverName, InetSocketAddress managementSocket) {
        HostControllerConnectionService smConnection = new HostControllerConnectionService();
        serviceTarget.addService(HostControllerConnectionService.SERVICE_NAME, (Service)smConnection).addInjection(smConnection.getSmAddressInjector(), (Object)managementSocket).setInitialMode(ServiceController.Mode.ACTIVE).install();
        HostControllerServerClient client = new HostControllerServerClient(serverName);
        serviceTarget.addService(HostControllerServerClient.SERVICE_NAME, (Service)client).addDependency(HostControllerConnectionService.SERVICE_NAME, Connection.class, client.getSmConnectionInjector()).addDependency(Services.JBOSS_SERVER_CONTROLLER, ServerController.class, client.getServerControllerInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static final class UninstallListener
    extends AbstractServiceListener<Object> {
        private final CountDownLatch latch;
        private final ServiceName name;

        UninstallListener(CountDownLatch latch, ServiceName name) {
            this.latch = latch;
            this.name = name;
        }

        public void serviceRemoved(ServiceController<?> controller) {
            if (controller.getName().equals(this.name)) {
                this.latch.countDown();
            }
        }
    }

    public static final class HostControllerCommunicationActivator
    implements ServiceActivator,
    Serializable {
        private static final long serialVersionUID = 6671220116719309952L;
        private final String serverName;
        private final InetSocketAddress managementSocket;

        public HostControllerCommunicationActivator(String serverName, InetSocketAddress managementSocket) {
            this.serverName = serverName;
            this.managementSocket = managementSocket;
        }

        public void activate(ServiceActivatorContext serviceActivatorContext) {
            ServiceTarget serviceTarget = serviceActivatorContext.getServiceTarget();
            DomainServerMain.addCommunicationServices(serviceTarget, this.serverName, this.managementSocket);
        }
    }
}

