/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.server.ServerOperationContext;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.server.services.net.SocketBindingManager;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

abstract class AbstractBindingWriteHandler
extends ServerWriteAttributeOperationHandler {
    private static final ServiceName SOCKET_BINDING = SocketBinding.JBOSS_BINDING_NAME;
    private static final ServiceName BINDING_MANAGER = SocketBindingManager.SOCKET_BINDING_MANAGER;

    protected AbstractBindingWriteHandler() {
    }

    protected AbstractBindingWriteHandler(ParameterValidator valueValidator) {
        super(valueValidator);
    }

    protected AbstractBindingWriteHandler(ParameterValidator valueValidator, ParameterValidator resolvedValueValidator) {
        super(valueValidator, resolvedValueValidator);
    }

    protected boolean requiresRestart() {
        return false;
    }

    abstract void handleRuntimeChange(ModelNode var1, String var2, ModelNode var3, SocketBinding var4) throws OperationFailedException;

    @Override
    protected void modelChanged(final OperationContext context, final ModelNode operation, final ResultHandler resultHandler, final String attributeName, final ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final PathElement element = address.getLastElement();
        if (context.getRuntimeContext() != null && context instanceof ServerOperationContext) {
            this.validateResolvedValue(attributeName, newValue);
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext runtimeTaskContext) throws OperationFailedException {
                    ServiceController controller = runtimeTaskContext.getServiceRegistry().getRequiredService(SOCKET_BINDING.append(new String[]{element.getValue()}));
                    if (controller != null) {
                        SocketBinding binding = (SocketBinding)SocketBinding.class.cast(controller.getValue());
                        if (AbstractBindingWriteHandler.this.requiresRestart() || binding.isBound()) {
                            ((ServerOperationContext)ServerOperationContext.class.cast(context)).restartRequired();
                        } else {
                            AbstractBindingWriteHandler.this.handleRuntimeChange(operation, attributeName, newValue, binding);
                        }
                        resultHandler.handleResultComplete();
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }
}

