/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.services.net.ManagedBinding;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class BindingMetricHandlers {
    private static final ServiceName SOCKET_BINDING = SocketBinding.JBOSS_BINDING_NAME;
    private static final ModelNode NO_METRICS = new ModelNode().set("no metrics available");

    private BindingMetricHandlers() {
    }

    public static class BoundPortHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound-port";
        public static final OperationHandler INSTANCE = new BoundPortHandler();

        private BoundPortHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ResultHandler handler) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                int port = managedBinding.getBindAddress().getPort();
                handler.handleResultFragment(Util.NO_LOCATION, new ModelNode().set(port));
            }
        }
    }

    public static class BoundAddressHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound-address";
        public static final OperationHandler INSTANCE = new BoundAddressHandler();

        private BoundAddressHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ResultHandler handler) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                InetAddress addr = managedBinding.getBindAddress().getAddress();
                handler.handleResultFragment(Util.NO_LOCATION, new ModelNode().set(addr.getHostAddress()));
            }
        }
    }

    public static class BoundHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound";
        public static final OperationHandler INSTANCE = new BoundHandler();

        private BoundHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ResultHandler handler) {
            handler.handleResultFragment(Util.NO_LOCATION, new ModelNode().set(binding.isBound()));
        }
    }

    static abstract class AbstractBindingMetricsHandler
    implements ModelQueryOperationHandler {
        AbstractBindingMetricsHandler() {
        }

        public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            final PathElement element = address.getLastElement();
            if (context.getRuntimeContext() != null) {
                context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                    public void execute(RuntimeTaskContext context) throws OperationFailedException {
                        ServiceController controller = context.getServiceRegistry().getRequiredService(SOCKET_BINDING.append(new String[]{element.getValue()}));
                        if (controller != null) {
                            SocketBinding binding = (SocketBinding)SocketBinding.class.cast(controller.getValue());
                            AbstractBindingMetricsHandler.this.execute(operation, binding, resultHandler);
                            resultHandler.handleResultComplete();
                        } else {
                            resultHandler.handleResultFragment(Util.NO_LOCATION, NO_METRICS);
                            resultHandler.handleResultComplete();
                        }
                    }
                });
            } else {
                resultHandler.handleResultFragment(Util.NO_LOCATION, NO_METRICS);
                resultHandler.handleResultComplete();
            }
            return new BasicOperationResult();
        }

        abstract void execute(ModelNode var1, SocketBinding var2, ResultHandler var3);
    }
}

