/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.path;

import java.io.File;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class AbsolutePathService
extends AbstractPathService {
    private final String absolutePath;

    public static ServiceController<String> addService(String name, String abstractPath, ServiceTarget serviceTarget) {
        return AbsolutePathService.addService(AbsolutePathService.pathNameOf(name), abstractPath, serviceTarget);
    }

    public static ServiceController<String> addService(ServiceName sname, String abstractPath, ServiceTarget serviceTarget) {
        AbsolutePathService service = new AbsolutePathService(abstractPath);
        return serviceTarget.addService(sname, (Service)service).install();
    }

    public static void addService(ServiceName name, ModelNode element, ServiceTarget serviceTarget) {
        String path = element.require("path").asString();
        AbsolutePathService.addService(name, path, serviceTarget);
    }

    public AbsolutePathService(String abstractPath) {
        if (abstractPath == null) {
            throw new IllegalArgumentException("abstractPath is null");
        }
        if (abstractPath.length() == 0) {
            throw new IllegalArgumentException("abstractPath is empty");
        }
        File f = new File(abstractPath);
        this.absolutePath = f.getAbsolutePath();
    }

    @Override
    protected String resolvePath() {
        return this.absolutePath;
    }
}

