/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedExecutorService;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.EventListener;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.QueuelessExecutor;

public class ManagedQueuelessExecutorService
extends ManagedExecutorService
implements BlockingExecutor {
    private final QueuelessExecutor executor;

    public ManagedQueuelessExecutorService(QueuelessExecutor executor) {
        super((ExecutorService)executor);
        this.executor = executor;
    }

    @Override
    protected ExecutorService protectExecutor(ExecutorService executor) {
        return JBossExecutors.protectedBlockingExecutorService((BlockingExecutor)((BlockingExecutor)executor));
    }

    @Override
    void internalShutdown() {
        this.executor.shutdown();
    }

    public boolean isBlocking() {
        return this.executor.isBlocking();
    }

    void setBlocking(boolean blocking) {
        this.executor.setBlocking(blocking);
    }

    public int getMaxThreads() {
        return this.executor.getMaxThreads();
    }

    void setMaxThreads(int maxThreads) {
        this.executor.setMaxThreads(maxThreads);
    }

    public long getKeepAlive() {
        return this.executor.getKeepAliveTime();
    }

    void setKeepAlive(long milliseconds) {
        this.executor.setKeepAliveTime(milliseconds);
    }

    public int getRejectedCount() {
        return this.executor.getRejectedCount();
    }

    public int getCurrentThreadCount() {
        return this.executor.getCurrentThreadCount();
    }

    public int getLargestThreadCount() {
        return this.executor.getLargestThreadCount();
    }

    <A> void addShutdownListener(EventListener<A> shutdownListener, A attachment) {
        this.executor.addShutdownListener(shutdownListener, attachment);
    }

    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        this.executor.executeBlocking(task);
    }

    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        this.executor.executeBlocking(task, timeout, unit);
    }

    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        this.executor.executeNonBlocking(task);
    }
}

