/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import com.arjuna.ats.arjuna.utils.Process;
import com.arjuna.ats.internal.arjuna.utils.UuidProcessId;
import java.util.ArrayList;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.as.txn.ArjunaObjectStoreEnvironmentService;
import org.jboss.as.txn.ArjunaRecoveryManagerService;
import org.jboss.as.txn.ArjunaTransactionManagerService;
import org.jboss.as.txn.CoreEnvironmentService;
import org.jboss.as.txn.ProcessIdType;
import org.jboss.as.txn.TransactionJndiBindingProcessor;
import org.jboss.as.txn.TransactionLogger;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.as.txn.TransactionSynchronizationRegistryService;
import org.jboss.as.txn.TxnServices;
import org.jboss.as.txn.UserTransactionRegistryService;
import org.jboss.as.txn.UserTransactionService;
import org.jboss.as.txn.XATerminatorService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.JBossXATerminator;
import org.omg.CORBA.ORB;

class TransactionSubsystemAdd
implements OperationStepHandler {
    static final TransactionSubsystemAdd INSTANCE = new TransactionSubsystemAdd();
    private static final ServiceName INTERNAL_OBJECTSTORE_PATH = TxnServices.JBOSS_TXN_PATHS.append(new String[]{"object-store"});
    private static final ServiceName INTERNAL_CORE_ENV_VAR_PATH = TxnServices.JBOSS_TXN_PATHS.append(new String[]{"core-var-dir"});

    private TransactionSubsystemAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) {
        ModelNode opAddr = operation.get("address");
        final String nodeIdentifier = operation.get("core-environment").hasDefined("node-identifier") ? operation.get(new String[]{"core-environment", "node-identifier"}).asString() : "1";
        final ModelNode processId = operation.get("core-environment").require("process-id");
        final String varDirPathRef = operation.get("core-environment").hasDefined("relative-to") ? operation.get("core-environment").get("relative-to").asString() : "jboss.server.data.dir";
        final String varDirPath = operation.get("core-environment").hasDefined("path") ? operation.get("core-environment").get("path").asString() : "var";
        final String recoveryBindingName = operation.get("recovery-environment").require("socket-binding").asString();
        final String recoveryStatusBindingName = operation.get("recovery-environment").require("status-socket-binding").asString();
        final boolean recoveryListener = operation.get(new String[]{"recovery-environment", "recovery-listener"}).asBoolean(false);
        final boolean coordinatorEnableStatistics = operation.get(new String[]{"coordinator-environment", "enable-statistics"}).asBoolean(false);
        final boolean transactionStatusManagerEnable = operation.get(new String[]{"coordinator-environment", "enable-tsm-status"}).asBoolean(false);
        ModelNode objectStore = operation.get("object-store");
        final String objectStorePathRef = objectStore.hasDefined("relative-to") ? objectStore.get("relative-to").asString() : "jboss.server.data.dir";
        final String objectStorePath = objectStore.hasDefined("path") ? objectStore.get("path").asString() : "tx-object-store";
        int maxPorts = 10;
        final int coordinatorDefaultTimeout = operation.get(new String[]{"coordinator-environment", "default-timeout"}).asInt(300);
        if (TransactionLogger.ROOT_LOGGER.isDebugEnabled()) {
            TransactionLogger.ROOT_LOGGER.debugf("nodeIdentifier=%s\n", nodeIdentifier);
            TransactionLogger.ROOT_LOGGER.debugf("varDirPathRef=%s, varDirPath=%s\n", varDirPathRef, varDirPath);
            TransactionLogger.ROOT_LOGGER.debugf("objectStorePathRef=%s, objectStorePathRef=%s\n", objectStorePathRef, objectStorePath);
            TransactionLogger.ROOT_LOGGER.debugf("recoveryBindingName=%s, recoveryStatusBindingName=%s\n", recoveryBindingName, recoveryStatusBindingName);
        }
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        subModel.get(new String[]{"core-environment", "process-id"}).set(operation.get("core-environment").require("process-id"));
        subModel.get(new String[]{"core-environment", "node-identifier"}).set(operation.get(new String[]{"core-environment", "node-identifier"}));
        subModel.get(new String[]{"core-environment", "relative-to"}).set(operation.get(new String[]{"core-environment", "relative-to"}));
        subModel.get(new String[]{"core-environment", "path"}).set(operation.get(new String[]{"core-environment", "path"}));
        subModel.get(new String[]{"recovery-environment", "socket-binding"}).set(operation.get("recovery-environment").require("socket-binding"));
        subModel.get(new String[]{"recovery-environment", "status-socket-binding"}).set(operation.get(new String[]{"recovery-environment", "status-socket-binding"}));
        subModel.get(new String[]{"recovery-environment", "recovery-listener"}).set(operation.get(new String[]{"recovery-environment", "recovery-listener"}));
        subModel.get(new String[]{"coordinator-environment", "enable-statistics"}).set(operation.get(new String[]{"coordinator-environment", "enable-statistics"}));
        subModel.get(new String[]{"coordinator-environment", "enable-tsm-status"}).set(operation.get(new String[]{"coordinator-environment", "enable-tsm-status"}));
        subModel.get(new String[]{"coordinator-environment", "default-timeout"}).set(coordinatorDefaultTimeout);
        subModel.get(new String[]{"object-store", "relative-to"}).set(operation.get(new String[]{"object-store", "relative-to"}));
        subModel.get(new String[]{"object-store", "path"}).set(operation.get(new String[]{"object-store", "path"}));
        boolean setReload = false;
        if (context.getType() == OperationContext.Type.SERVER) {
            if (!context.isBooting()) {
                context.reloadRequired();
                setReload = true;
            } else {
                context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                    protected void execute(DeploymentProcessorTarget processorTarget) {
                        processorTarget.addDeploymentProcessor(Phase.INSTALL, 6400, (DeploymentUnitProcessor)new TransactionJndiBindingProcessor());
                    }
                }, OperationContext.Stage.RUNTIME);
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) {
                        UuidProcessId id;
                        ArrayList<Object> controllers = new ArrayList<Object>();
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        ServiceTarget target = context.getServiceTarget();
                        String socketBindingName = null;
                        CoreEnvironmentService coreEnvironmentService = new CoreEnvironmentService(nodeIdentifier, varDirPath);
                        if (processId.hasDefined(ProcessIdType.UUID.getName())) {
                            id = new UuidProcessId();
                            coreEnvironmentService.setProcessImplementation((Process)id);
                        } else if (processId.hasDefined(ProcessIdType.SOCKET.getName())) {
                            coreEnvironmentService.setProcessImplementationClassName(ProcessIdType.SOCKET.getClazz());
                            ModelNode socket = processId.get(ProcessIdType.SOCKET.getName());
                            socketBindingName = socket.require("socket-binding").asString();
                            if (socket.hasDefined("max-ports")) {
                                int ports = socket.get("max-ports").asInt(10);
                                coreEnvironmentService.setSocketProcessIdMaxPorts(ports);
                            }
                        } else {
                            id = new UuidProcessId();
                            coreEnvironmentService.setProcessImplementation((Process)id);
                        }
                        ServiceBuilder coreEnvBuilder = target.addService(TxnServices.JBOSS_TXN_CORE_ENVIRONMENT, (Service)coreEnvironmentService);
                        if (socketBindingName != null) {
                            ServiceName bindingName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName});
                            coreEnvBuilder.addDependency(bindingName, SocketBinding.class, coreEnvironmentService.getSocketProcessBindingInjector());
                        }
                        ServiceController varDirRPS = RelativePathService.addService((ServiceName)INTERNAL_CORE_ENV_VAR_PATH, (String)varDirPath, (String)varDirPathRef, (ServiceTarget)target);
                        controllers.add(varDirRPS);
                        controllers.add(coreEnvBuilder.addDependency(varDirRPS.getName(), String.class, coreEnvironmentService.getPathInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
                        XATerminatorService xaTerminatorService = new XATerminatorService();
                        controllers.add(target.addService(TxnServices.JBOSS_TXN_XA_TERMINATOR, (Service)xaTerminatorService).setInitialMode(ServiceController.Mode.ACTIVE).install());
                        ServiceController objectStoreRPS = RelativePathService.addService((ServiceName)INTERNAL_OBJECTSTORE_PATH, (String)objectStorePath, (String)objectStorePathRef, (ServiceTarget)target);
                        controllers.add(objectStoreRPS);
                        boolean useHornetqJournalStore = "true".equals(System.getProperty("usehornetqstore"));
                        ArjunaObjectStoreEnvironmentService objStoreEnvironmentService = new ArjunaObjectStoreEnvironmentService(useHornetqJournalStore);
                        controllers.add(target.addService(TxnServices.JBOSS_TXN_ARJUNA_OBJECTSTORE_ENVIRONMENT, (Service)objStoreEnvironmentService).addDependency(objectStoreRPS.getName(), String.class, objStoreEnvironmentService.getPathInjector()).addDependency(TxnServices.JBOSS_TXN_CORE_ENVIRONMENT).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
                        ArjunaRecoveryManagerService recoveryManagerService = new ArjunaRecoveryManagerService(recoveryListener);
                        controllers.add(target.addService(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, (Service)recoveryManagerService).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"iiop", "orb"}), ORB.class, recoveryManagerService.getOrbInjector()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{recoveryBindingName}), SocketBinding.class, recoveryManagerService.getRecoveryBindingInjector()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{recoveryStatusBindingName}), SocketBinding.class, recoveryManagerService.getStatusBindingInjector()).addDependency(TxnServices.JBOSS_TXN_CORE_ENVIRONMENT).addDependency(TxnServices.JBOSS_TXN_ARJUNA_OBJECTSTORE_ENVIRONMENT).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
                        ArjunaTransactionManagerService transactionManagerService = new ArjunaTransactionManagerService(coordinatorEnableStatistics, coordinatorDefaultTimeout, transactionStatusManagerEnable);
                        controllers.add(target.addService(TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER, (Service)transactionManagerService).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"iiop", "orb"}), ORB.class, transactionManagerService.getOrbInjector()).addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, transactionManagerService.getXaTerminatorInjector()).addDependency(TxnServices.JBOSS_TXN_CORE_ENVIRONMENT).addDependency(TxnServices.JBOSS_TXN_ARJUNA_OBJECTSTORE_ENVIRONMENT).addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
                        controllers.add(TransactionManagerService.addService(target, verificationHandler));
                        controllers.add(UserTransactionService.addService(target, verificationHandler));
                        controllers.add(target.addService(TxnServices.JBOSS_TXN_USER_TRANSACTION_REGISTRY, (Service)new UserTransactionRegistryService()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
                        controllers.add(TransactionSynchronizationRegistryService.addService(target, verificationHandler));
                        final BinderService tmBinderService = new BinderService("TransactionManager");
                        ServiceBuilder tmBuilder = context.getServiceTarget().addService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{"TransactionManager"}), (Service)tmBinderService);
                        tmBuilder.addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, tmBinderService.getNamingStoreInjector());
                        tmBuilder.addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, (Injector)new Injector<TransactionManager>(){

                            public void inject(TransactionManager value) throws InjectionException {
                                tmBinderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)value)));
                            }

                            public void uninject() {
                                tmBinderService.getNamingStoreInjector().uninject();
                            }
                        });
                        tmBuilder.install();
                        final BinderService tsrBinderService = new BinderService("TransactionSynchronizationRegistry");
                        ServiceBuilder tsrBuilder = context.getServiceTarget().addService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{"TransactionSynchronizationRegistry"}), (Service)tsrBinderService);
                        tsrBuilder.addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, tsrBinderService.getNamingStoreInjector());
                        tsrBuilder.addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, TransactionSynchronizationRegistry.class, (Injector)new Injector<TransactionSynchronizationRegistry>(){

                            public void inject(TransactionSynchronizationRegistry value) throws InjectionException {
                                tsrBinderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)value)));
                            }

                            public void uninject() {
                                tsrBinderService.getNamingStoreInjector().uninject();
                            }
                        });
                        tsrBuilder.install();
                        final BinderService utBinderService = new BinderService("UserTransaction");
                        ServiceBuilder utBuilder = context.getServiceTarget().addService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{"UserTransaction"}), (Service)utBinderService);
                        utBuilder.addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, utBinderService.getNamingStoreInjector());
                        utBuilder.addDependency(UserTransactionService.SERVICE_NAME, UserTransaction.class, (Injector)new Injector<UserTransaction>(){

                            public void inject(UserTransaction value) throws InjectionException {
                                utBinderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)value)));
                            }

                            public void uninject() {
                                utBinderService.getNamingStoreInjector().uninject();
                            }
                        });
                        utBuilder.install();
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                            for (ServiceController serviceController : controllers) {
                                context.removeService(serviceController.getName());
                            }
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK && setReload) {
            context.revertReloadRequired();
        }
    }
}

