/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.web.Attribute;
import org.jboss.as.web.Element;
import org.jboss.as.web.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class WebSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final WebSubsystemParser INSTANCE = new WebSubsystemParser();

    WebSubsystemParser() {
    }

    static WebSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode config;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        WebSubsystemParser.writeAttribute(writer, Attribute.NATIVE.getLocalName(), node);
        WebSubsystemParser.writeAttribute(writer, Attribute.DEFAULT_VIRTUAL_SERVER.getLocalName(), node);
        if (node.hasDefined("configuration")) {
            this.writeContainerConfig(writer, node.get("configuration"));
        }
        if (node.hasDefined("connector")) {
            for (Property connector : node.get("connector").asPropertyList()) {
                config = connector.getValue();
                writer.writeStartElement(Element.CONNECTOR.getLocalName());
                writer.writeAttribute("name", connector.getName());
                WebSubsystemParser.writeAttribute(writer, Attribute.PROTOCOL.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.SOCKET_BINDING.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.SCHEME.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.ENABLED.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.ENABLE_LOOKUPS.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.PROXY_NAME.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.PROXY_PORT.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.SECURE.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.EXECUTOR.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.MAX_POST_SIZE.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.MAX_SAVE_POST_SIZE.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.MAX_CONNECTIONS.getLocalName(), config);
                WebSubsystemParser.writeAttribute(writer, Attribute.REDIRECT_PORT.getLocalName(), config);
                if (config.hasDefined("ssl")) {
                    writer.writeStartElement(Element.SSL.getLocalName());
                    ModelNode sslConfig = config.get("ssl");
                    WebSubsystemParser.writeAttribute(writer, Attribute.NAME.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.KEY_ALIAS.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.PASSWORD.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CERTIFICATE_KEY_FILE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CIPHER_SUITE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.PROTOCOL.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.VERIFY_CLIENT.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.VERIFY_DEPTH.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CERTIFICATE_FILE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CA_CERTIFICATE_FILE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.CA_REVOCATION_URL.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.SESSION_CACHE_SIZE.getLocalName(), sslConfig);
                    WebSubsystemParser.writeAttribute(writer, Attribute.SESSION_TIMEOUT.getLocalName(), sslConfig);
                    writer.writeEndElement();
                }
                if (config.hasDefined("virtual-server")) {
                    for (ModelNode virtualServer : config.get("virtual-server").asList()) {
                        writer.writeEmptyElement("virtual-server");
                        writer.writeAttribute("name", virtualServer.asString());
                    }
                }
                writer.writeEndElement();
            }
        }
        if (node.hasDefined("virtual-server")) {
            for (Property host : node.get("virtual-server").asPropertyList()) {
                config = host.getValue();
                writer.writeStartElement(Element.VIRTUAL_SERVER.getLocalName());
                writer.writeAttribute("name", host.getName());
                WebSubsystemParser.writeAttribute(writer, Attribute.DEFAULT_WEB_MODULE.getLocalName(), config);
                if (config.hasDefined("enable-welcome-root") && config.get("enable-welcome-root").asBoolean()) {
                    writer.writeAttribute("enable-welcome-root", "true");
                }
                if (config.hasDefined("alias")) {
                    for (ModelNode alias : config.get("alias").asList()) {
                        writer.writeEmptyElement("alias");
                        writer.writeAttribute("name", alias.asString());
                    }
                }
                if (config.hasDefined("access-log")) {
                    writer.writeStartElement(Element.ACCESS_LOG.getLocalName());
                    ModelNode accessLog = config.get("access-log");
                    if (accessLog.has("directory")) {
                        writer.writeEmptyElement("directory");
                        WebSubsystemParser.writeAttribute(writer, Attribute.PATH.getLocalName(), accessLog);
                        WebSubsystemParser.writeAttribute(writer, Attribute.RELATIVE_TO.getLocalName(), accessLog);
                    }
                    WebSubsystemParser.writeAttribute(writer, Attribute.PATTERN.getLocalName(), config);
                    WebSubsystemParser.writeAttribute(writer, Attribute.RESOLVE_HOSTS.getLocalName(), config);
                    WebSubsystemParser.writeAttribute(writer, Attribute.EXTENDED.getLocalName(), config);
                    WebSubsystemParser.writeAttribute(writer, Attribute.PREFIX.getLocalName(), config);
                    WebSubsystemParser.writeAttribute(writer, Attribute.ROTATE.getLocalName(), config);
                    writer.writeEndElement();
                }
                if (config.hasDefined("rewrite")) {
                    for (ModelNode rewrite : config.get("rewrite").asList()) {
                        writer.writeStartElement("rewrite");
                        if (rewrite.hasDefined("condition")) {
                            for (ModelNode condition : rewrite.get("condition").asList()) {
                                writer.writeStartElement("condition");
                                WebSubsystemParser.writeAttribute(writer, Attribute.TEST.getLocalName(), condition);
                                WebSubsystemParser.writeAttribute(writer, Attribute.PATTERN.getLocalName(), condition);
                                WebSubsystemParser.writeAttribute(writer, Attribute.FLAGS.getLocalName(), condition);
                                writer.writeEndElement();
                            }
                        }
                        WebSubsystemParser.writeAttribute(writer, Attribute.PATTERN.getLocalName(), rewrite);
                        WebSubsystemParser.writeAttribute(writer, Attribute.SUBSTITUTION.getLocalName(), rewrite);
                        WebSubsystemParser.writeAttribute(writer, Attribute.FLAGS.getLocalName(), rewrite);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeContainerConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
        if (config.hasDefined("static-resources")) {
            this.writeStaticResources(writer, config.get("static-resources"));
        }
        if (config.hasDefined("jsp-configuration")) {
            this.writeJSPConfiguration(writer, config.get("jsp-configuration"));
        }
        if (config.hasDefined("mime-mapping")) {
            for (Property entry : config.get("mime-mapping").asPropertyList()) {
                writer.writeEmptyElement(Element.MIME_MAPPING.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), entry.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), entry.getValue().asString());
            }
        }
        if (config.hasDefined("welcome-file")) {
            for (ModelNode file : config.get("welcome-file").asList()) {
                writer.writeStartElement(Element.WELCOME_FILE.getLocalName());
                writer.writeCharacters(file.asString());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeStaticResources(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.STATIC_RESOURCES.getLocalName());
        WebSubsystemParser.writeAttribute(writer, Attribute.LISTINGS.getLocalName(), config);
        WebSubsystemParser.writeAttribute(writer, Attribute.SENDFILE.getLocalName(), config);
        WebSubsystemParser.writeAttribute(writer, Attribute.FILE_ENCONDING.getLocalName(), config);
        WebSubsystemParser.writeAttribute(writer, Attribute.READ_ONLY.getLocalName(), config);
        WebSubsystemParser.writeAttribute(writer, Attribute.WEBDAV.getLocalName(), config);
        WebSubsystemParser.writeAttribute(writer, Attribute.SECRET.getLocalName(), config);
        WebSubsystemParser.writeAttribute(writer, Attribute.MAX_DEPTH.getLocalName(), config);
        WebSubsystemParser.writeAttribute(writer, Attribute.DISABLED.getLocalName(), config);
        writer.writeEndElement();
    }

    private void writeJSPConfiguration(XMLExtendedStreamWriter writer, ModelNode jsp) throws XMLStreamException {
        writer.writeStartElement(Element.JSP_CONFIGURATION.getLocalName());
        WebSubsystemParser.writeAttribute(writer, Attribute.DEVELOPMENT.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.KEEP_GENERATED.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.TRIM_SPACES.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.TAG_POOLING.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.MAPPED_FILE.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.CHECK_INTERVAL.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.MODIFIFICATION_TEST_INTERVAL.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.RECOMPILE_ON_FAIL.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.SMAP.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.DUMP_SMAP.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.GENERATE_STRINGS_AS_CHAR_ARRAYS.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.SCRATCH_DIR.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.SOURCE_VM.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.TARGET_VM.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.JAVA_ENCODING.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.X_POWERED_BY.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.DISPLAY_SOURCE_FRAGMENT.getLocalName(), jsp);
        WebSubsystemParser.writeAttribute(writer, Attribute.DISABLED.getLocalName(), jsp);
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "web");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NATIVE: 
                case DEFAULT_VIRTUAL_SERVER: {
                    subsystem.get(attribute.getLocalName()).set(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(subsystem);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONTAINER_CONFIG: {
                            ModelNode config = WebSubsystemParser.parseContainerConfig(reader);
                            subsystem.get("configuration").set(config);
                            continue block12;
                        }
                        case CONNECTOR: {
                            WebSubsystemParser.parseConnector(reader, address, list);
                            continue block12;
                        }
                        case VIRTUAL_SERVER: {
                            WebSubsystemParser.parseHost(reader, address, list);
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode parseContainerConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode config = new ModelNode();
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATIC_RESOURCES: {
                    ModelNode resourceServing = WebSubsystemParser.parseStaticResources(reader);
                    config.get("static-resources").set(resourceServing);
                    continue block6;
                }
                case JSP_CONFIGURATION: {
                    ModelNode jspConfiguration = WebSubsystemParser.parseJSPConfiguration(reader);
                    config.get("jsp-configuration").set(jspConfiguration);
                    continue block6;
                }
                case MIME_MAPPING: {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                    config.get("mime-mapping").get(array[0]).set(array[1]);
                    continue block6;
                }
                case WELCOME_FILE: {
                    String welcomeFile = reader.getElementText().trim();
                    config.get("welcome-file").add(welcomeFile);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return config;
    }

    static ModelNode parseJSPConfiguration(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode jsp = new ModelNode();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEVELOPMENT: 
                case DISABLED: 
                case KEEP_GENERATED: 
                case TRIM_SPACES: 
                case TAG_POOLING: 
                case MAPPED_FILE: 
                case CHECK_INTERVAL: 
                case MODIFIFICATION_TEST_INTERVAL: 
                case RECOMPILE_ON_FAIL: 
                case SMAP: 
                case DUMP_SMAP: 
                case GENERATE_STRINGS_AS_CHAR_ARRAYS: 
                case ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE: 
                case SCRATCH_DIR: 
                case SOURCE_VM: 
                case TARGET_VM: 
                case JAVA_ENCODING: 
                case X_POWERED_BY: 
                case DISPLAY_SOURCE_FRAGMENT: {
                    jsp.get(attribute.getLocalName()).set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return jsp;
    }

    static ModelNode parseStaticResources(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode resources = new ModelNode();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LISTINGS: {
                    resources.get("listings").set(value);
                    continue block10;
                }
                case SENDFILE: {
                    resources.get("sendfile").set(value);
                    continue block10;
                }
                case FILE_ENCONDING: {
                    resources.get("file-encoding").set(value);
                    continue block10;
                }
                case READ_ONLY: {
                    resources.get("read-only").set(value);
                    continue block10;
                }
                case WEBDAV: {
                    resources.get("webdav").set(value);
                    continue block10;
                }
                case SECRET: {
                    resources.get("secret").set(value);
                    continue block10;
                }
                case MAX_DEPTH: {
                    resources.get("max-depth").set(value);
                    continue block10;
                }
                case DISABLED: {
                    resources.get("disabled").set(value);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return resources;
    }

    static void parseHost(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String defaultWebModule = null;
        boolean welcome = false;
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case DEFAULT_WEB_MODULE: {
                    if (welcome) {
                        throw new XMLStreamException("A default web module can not be specified when the welcome root has been enabled", reader.getLocation());
                    }
                    defaultWebModule = value;
                    continue block13;
                }
                case ENABLE_WELCOME_ROOT: {
                    welcome = Boolean.parseBoolean(value);
                    if (!welcome || defaultWebModule == null) continue block13;
                    throw new XMLStreamException("The welcome root can not be enabled on a host that has a default web module", reader.getLocation());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode host = new ModelNode();
        host.get("operation").set("add");
        host.get("address").set(address).add("virtual-server", name);
        if (defaultWebModule != null) {
            host.get("default-web-module").set(defaultWebModule);
        }
        host.get("enable-welcome-root").set(welcome);
        list.add(host);
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALIAS: {
                            host.get("alias").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block14;
                        }
                        case ACCESS_LOG: {
                            ModelNode log = WebSubsystemParser.parseHostAccessLog(reader);
                            host.get("access-log").set(log);
                            continue block14;
                        }
                        case REWRITE: {
                            ModelNode rewrite = WebSubsystemParser.parseHostRewrite(reader);
                            host.get("rewrite").add(rewrite);
                            continue block14;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode parseHostRewrite(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode rewrite = new ModelNode();
        rewrite.setEmptyObject();
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATTERN: {
                    rewrite.get("pattern").set(value);
                    continue block16;
                }
                case SUBSTITUTION: {
                    rewrite.get("substitution").set(value);
                    continue block16;
                }
                case FLAGS: {
                    rewrite.get("rewrite").set(value);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONDITION: {
                            ModelNode condition = new ModelNode();
                            condition.setEmptyObject();
                            int count2 = reader.getAttributeCount();
                            block18: for (int i = 0; i < count2; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                String value = reader.getAttributeValue(i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case TEST: {
                                        condition.get("test").set(value);
                                        continue block18;
                                    }
                                    case PATTERN: {
                                        condition.get("pattern").set(value);
                                        continue block18;
                                    }
                                    case FLAGS: {
                                        condition.get("flags").set(value);
                                        continue block18;
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            rewrite.get("condition").add(condition);
                            continue block17;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return rewrite;
    }

    static ModelNode parseHostAccessLog(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode log = new ModelNode();
        log.setEmptyObject();
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATTERN: {
                    log.get("pattern").set(value);
                    continue block17;
                }
                case RESOLVE_HOSTS: {
                    log.get("resolve-hosts").set(value);
                    continue block17;
                }
                case EXTENDED: {
                    log.get("extended").set(value);
                    continue block17;
                }
                case PREFIX: {
                    log.get("prefix").set(value);
                    continue block17;
                }
                case ROTATE: {
                    log.get("rotate").set(value);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block18: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case DIRECTORY: {
                            ModelNode directory = new ModelNode();
                            log.get("directory").set(directory);
                            int count2 = reader.getAttributeCount();
                            block19: for (int i = 0; i < count2; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                String value = reader.getAttributeValue(i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case PATH: {
                                        directory.get("path").set(value);
                                        continue block19;
                                    }
                                    case RELATIVE_TO: {
                                        directory.get("relative-to").set(value);
                                        continue block19;
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            continue block18;
                        }
                        default: {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                    }
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return log;
    }

    static void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String protocol = null;
        String bindingRef = null;
        String scheme = null;
        String executorRef = null;
        String enabled = null;
        String enableLookups = null;
        String proxyName = null;
        String proxyPort = null;
        String maxPostSize = null;
        String maxSavePostSize = null;
        String secure = null;
        String redirectPort = null;
        String maxConnections = null;
        int count = reader.getAttributeCount();
        block23: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block23;
                }
                case SOCKET_BINDING: {
                    bindingRef = value;
                    continue block23;
                }
                case SCHEME: {
                    scheme = value;
                    continue block23;
                }
                case PROTOCOL: {
                    protocol = value;
                    continue block23;
                }
                case EXECUTOR: {
                    executorRef = value;
                    continue block23;
                }
                case ENABLED: {
                    enabled = value;
                    continue block23;
                }
                case ENABLE_LOOKUPS: {
                    enableLookups = value;
                    continue block23;
                }
                case PROXY_NAME: {
                    proxyName = value;
                    continue block23;
                }
                case PROXY_PORT: {
                    proxyPort = value;
                    continue block23;
                }
                case MAX_POST_SIZE: {
                    maxPostSize = value;
                    continue block23;
                }
                case MAX_SAVE_POST_SIZE: {
                    maxSavePostSize = value;
                    continue block23;
                }
                case SECURE: {
                    secure = value;
                    continue block23;
                }
                case REDIRECT_PORT: {
                    redirectPort = value;
                    continue block23;
                }
                case MAX_CONNECTIONS: {
                    maxConnections = value;
                    continue block23;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (bindingRef == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
        }
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        connector.get("address").set(address).add("connector", name);
        block24: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SSL: {
                            ModelNode ssl = WebSubsystemParser.parseSsl(reader);
                            connector.get("ssl").set(ssl);
                            continue block24;
                        }
                        case VIRTUAL_SERVER: {
                            connector.get("virtual-server").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block24;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (protocol != null) {
            connector.get("protocol").set(protocol);
        }
        connector.get("socket-binding").set(bindingRef);
        if (scheme != null) {
            connector.get("scheme").set(scheme);
        }
        if (executorRef != null) {
            connector.get("executor").set(executorRef);
        }
        if (enabled != null) {
            connector.get("enabled").set(enabled);
        }
        if (enableLookups != null) {
            connector.get("enable-lookups").set(enableLookups);
        }
        if (proxyName != null) {
            connector.get("proxy-name").set(proxyName);
        }
        if (proxyPort != null) {
            connector.get("proxy-port").set(proxyPort);
        }
        if (maxPostSize != null) {
            connector.get("max-post-size").set(maxPostSize);
        }
        if (maxSavePostSize != null) {
            connector.get("max-save-post-size").set(maxSavePostSize);
        }
        if (secure != null) {
            connector.get("secure").set(secure);
        }
        if (redirectPort != null) {
            connector.get("redirect-port").set(redirectPort);
        }
        if (maxConnections != null) {
            connector.get("max-connections").set(maxConnections);
        }
        list.add(connector);
    }

    static ModelNode parseSsl(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.setEmptyObject();
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    ssl.get("name").set(value);
                    continue block15;
                }
                case KEY_ALIAS: {
                    ssl.get("key-alias").set(value);
                    continue block15;
                }
                case PASSWORD: {
                    ssl.get("password").set(value);
                    continue block15;
                }
                case CERTIFICATE_KEY_FILE: {
                    ssl.get("certificate-key-file").set(value);
                    continue block15;
                }
                case CIPHER_SUITE: {
                    ssl.get("cipher-suite").set(value);
                    continue block15;
                }
                case PROTOCOL: {
                    ssl.get("protocol").set(value);
                    continue block15;
                }
                case VERIFY_CLIENT: {
                    ssl.get("verify-client").set(value);
                    continue block15;
                }
                case VERIFY_DEPTH: {
                    ssl.get("verify-depth").set(Integer.valueOf(value).intValue());
                    continue block15;
                }
                case CERTIFICATE_FILE: {
                    ssl.get("certificate-file").set(value);
                    continue block15;
                }
                case CA_CERTIFICATE_FILE: {
                    ssl.get("ca-certificate-file").set(value);
                    continue block15;
                }
                case CA_REVOCATION_URL: {
                    ssl.get("ca-revocation-url").set(value);
                    continue block15;
                }
                case SESSION_CACHE_SIZE: {
                    ssl.get("session-cache-size").set(value);
                    continue block15;
                }
                case SESSION_TIMEOUT: {
                    ssl.get("session-timeout").set(value);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return ssl;
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeAttribute(name, node.get(name).asString());
        }
    }
}

