/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WelcomeContextService
implements Service<Context> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.web");
    private final StandardContext context;
    private final InjectedValue<String> pathInjector = new InjectedValue();
    private final InjectedValue<VirtualHost> hostInjector = new InjectedValue();

    public WelcomeContextService() {
        this.context = new StandardContext();
    }

    public synchronized void start(StartContext startContext) throws StartException {
        try {
            this.context.setPath("");
            this.context.addLifecycleListener((LifecycleListener)new ContextConfig());
            this.context.setDocBase((String)this.pathInjector.getValue() + File.separatorChar + "welcome-content");
            WebCtxLoader loader = new WebCtxLoader(this.getClass().getClassLoader());
            Host host = ((VirtualHost)this.hostInjector.getValue()).getHost();
            loader.setContainer((Container)host);
            this.context.setLoader((Loader)loader);
            this.context.setInstanceManager((InstanceManager)new LocalInstanceManager());
            this.context.setReplaceWelcomeFiles(true);
            this.context.addWelcomeFile("index.html");
            Wrapper wrapper = this.context.createWrapper();
            wrapper.setName("DefaultServlet");
            wrapper.setServletClass("org.apache.catalina.servlets.DefaultServlet");
            this.context.addChild((Container)wrapper);
            this.context.addServletMapping("/", "DefaultServlet");
            this.context.addMimeMapping("html", "text/html");
            this.context.addMimeMapping("jpg", "image/jpeg");
            host.addChild((Container)this.context);
            this.context.create();
        }
        catch (Exception e) {
            throw new StartException("failed to create context", (Throwable)e);
        }
        try {
            this.context.start();
        }
        catch (LifecycleException e) {
            throw new StartException("failed to start context", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        try {
            ((VirtualHost)this.hostInjector.getValue()).getHost().removeChild((Container)this.context);
            this.context.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)"exception while stopping context", (Throwable)e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            log.error((Object)"exception while destroying context", (Throwable)e);
        }
    }

    public synchronized Context getValue() throws IllegalStateException {
        StandardContext context = this.context;
        if (context == null) {
            throw new IllegalStateException();
        }
        return context;
    }

    public InjectedValue<String> getPathInjector() {
        return this.pathInjector;
    }

    public InjectedValue<VirtualHost> getHostInjector() {
        return this.hostInjector;
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        private LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

