/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.NamingListener;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.JBossContextConfig;
import org.jboss.as.web.deployment.ServletContextAttribute;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.WebContextInjector;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.web.deployment.WebDeploymentService;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.as.web.security.JBossWebRealmService;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.security.SecurityUtil;
import org.jboss.vfs.VirtualFile;

public class WarDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String defaultHost;

    public WarDeploymentProcessor(String defaultHost) {
        if (defaultHost == null) {
            throw new IllegalArgumentException("null default host");
        }
        this.defaultHost = defaultHost;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String hostName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        Collection<Object> hostNames = null;
        if (metaData.getMergedJBossWebMetaData() != null) {
            hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        }
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(this.defaultHost);
        }
        if ((hostName = (String)hostNames.iterator().next()) == null) {
            throw new IllegalStateException("null host name");
        }
        this.processDeployment(hostName, metaData, deploymentUnit, phaseContext.getServiceTarget());
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void processDeployment(String hostName, WarMetaData warMetaData, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException("failed to resolve module for deployment " + deploymentRoot);
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        StandardContext webContext = new StandardContext();
        JBossContextConfig config = new JBossContextConfig(deploymentUnit);
        webContext.addInstanceListener(NamingListener.class.getName());
        try {
            webContext.setDocBase(deploymentRoot.getPhysicalFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        webContext.addLifecycleListener((LifecycleListener)config);
        String deploymentName = deploymentUnit.getName();
        String pathName = null;
        if (metaData.getContextRoot() == null) {
            pathName = "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if ("/".equals(pathName)) {
                pathName = "";
            } else if (pathName.length() > 0 && pathName.charAt(0) != '/') {
                pathName = "/" + pathName;
            }
        }
        webContext.setPath(pathName);
        webContext.setIgnoreAnnotations(true);
        webContext.setCrossContext(!metaData.isDisableCrossContext());
        WebInjectionContainer injectionContainer = new WebInjectionContainer((ClassLoader)module.getClassLoader());
        Map components = (Map)deploymentUnit.getAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS);
        if (components != null) {
            for (Map.Entry entry : components.entrySet()) {
                injectionContainer.addInstantiator((String)entry.getKey(), (ComponentInstantiator)entry.getValue());
            }
        }
        webContext.setInstanceManager((InstanceManager)injectionContainer);
        WebCtxLoader loader = new WebCtxLoader((ClassLoader)classLoader);
        webContext.setLoader((Loader)loader);
        switch (metaData.getSessionCookies()) {
            case 1: {
                webContext.setCookies(true);
                break;
            }
            case 2: {
                webContext.setCookies(false);
            }
        }
        String metaDataSecurityDomain = metaData.getSecurityDomain();
        if (metaDataSecurityDomain != null) {
            metaDataSecurityDomain = metaDataSecurityDomain.trim();
        }
        String securityDomain = metaDataSecurityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain);
        Map principalVersusRolesMap = metaData.getSecurityRoles().getPrincipalVersusRolesMap();
        List attributes = (List)deploymentUnit.getAttachment(ServletContextAttribute.ATTACHMENT_KEY);
        if (attributes != null) {
            ServletContext context = webContext.getServletContext();
            for (ServletContextAttribute attribute : attributes) {
                context.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        try {
            JBossWebRealmService realmService = new JBossWebRealmService(principalVersusRolesMap);
            ServiceBuilder builder = serviceTarget.addService(WebSubsystemServices.JBOSS_WEB_REALM.append(new String[]{deploymentName}), (Service)realmService);
            builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}), SecurityDomainContext.class, realmService.getSecurityDomainContextInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            WebDeploymentService webDeploymentService = new WebDeploymentService(webContext, injectionContainer);
            if (moduleDescription != null) {
                webDeploymentService.getNamespaceSelector().setValue((Value)new ImmediateValue((Object)moduleDescription.getNamespaceContextSelector()));
            }
            builder = serviceTarget.addService(WebSubsystemServices.JBOSS_WEB.append(new String[]{deploymentName}), (Service)webDeploymentService);
            builder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName}), VirtualHost.class, (Injector)new WebContextInjector((Context)webContext)).addDependencies(injectionContainer.getServiceNames());
            builder.addDependency(WebSubsystemServices.JBOSS_WEB_REALM.append(new String[]{deploymentName}), Realm.class, webDeploymentService.getRealm());
            builder.addDependencies((Iterable)deploymentUnit.getAttachmentList(Attachments.WEB_DEPENDENCIES));
            builder.install();
        }
        catch (ServiceRegistryException e) {
            throw new DeploymentUnitProcessingException("Failed to add JBoss web deployment service", (Throwable)e);
        }
    }
}

