/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.jboss.as.web.VirtualHost;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

class WebContextInjector
implements Injector<VirtualHost> {
    private volatile VirtualHost host;
    private final Value<Context> context;

    public WebContextInjector(Value<Context> context) {
        this.context = context;
    }

    public WebContextInjector(Context context) {
        this.context = Values.immediateValue((Object)context);
    }

    public void inject(VirtualHost host) throws InjectionException {
        this.host = host;
        Context context = (Context)this.context.getValue();
        if (("/" + host.getHost().getDefaultWebapp()).equals(context.getPath())) {
            if (host.hasWelcomeRoot()) {
                throw new IllegalStateException("Root contexts can not be deployed when the virtual host configuration has the welcome root enabled, disable it and redeploy");
            }
            context.setPath("");
        }
        context.getLoader().setContainer((Container)host.getHost());
        host.getHost().addChild((Container)context);
    }

    public void uninject() {
        VirtualHost host = this.host;
        if (host != null) {
            Context context = (Context)this.context.getValue();
            host.getHost().removeChild((Container)context);
            this.host = null;
        }
    }
}

