/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.web.NamingListener;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.as.web.deployment.jsf.JsfInjectionProvider;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebDeploymentService
implements Service<Context> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.web");
    private final StandardContext context;
    private final InjectedValue<NamespaceContextSelector> namespaceSelector = new InjectedValue();
    private final InjectedValue<Realm> realm = new InjectedValue();
    private final WebInjectionContainer injectionContainer;

    public WebDeploymentService(StandardContext context, WebInjectionContainer injectionContainer) {
        this.context = context;
        this.injectionContainer = injectionContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        this.context.setRealm((Realm)this.realm.getValue());
        JsfInjectionProvider.getInjectionContainer().set(this.injectionContainer);
        try {
            NamingListener.beginComponentStart((NamespaceContextSelector)this.namespaceSelector.getOptionalValue());
            try {
                try {
                    this.context.create();
                }
                catch (Exception e) {
                    throw new StartException("failed to create context", (Throwable)e);
                }
                try {
                    this.context.start();
                }
                catch (LifecycleException e) {
                    throw new StartException("failed to start context", (Throwable)e);
                }
                log.info((Object)("registering web context: " + this.context.getName()));
            }
            finally {
                NamingListener.endComponentStart();
            }
        }
        finally {
            JsfInjectionProvider.getInjectionContainer().set(null);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        try {
            this.context.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)"exception while stopping context", (Throwable)e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            log.error((Object)"exception while destroying context", (Throwable)e);
        }
    }

    public synchronized Context getValue() throws IllegalStateException {
        StandardContext context = this.context;
        if (context == null) {
            throw new IllegalStateException();
        }
        return context;
    }

    public InjectedValue<NamespaceContextSelector> getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public InjectedValue<Realm> getRealm() {
        return this.realm;
    }
}

