/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.as.clustering.web.DistributedCacheManagerFactory;
import org.jboss.as.clustering.web.DistributedCacheManagerFactoryService;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.JaccService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebDeploymentDefinition;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.JBossContextConfig;
import org.jboss.as.web.deployment.ServletContextAttribute;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WarSecurityDeployer;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.WebContextInjector;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.web.deployment.WebDeploymentService;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.as.web.deployment.component.ComponentInstantiator;
import org.jboss.as.web.ext.WebContextFactory;
import org.jboss.as.web.security.JBossWebRealmService;
import org.jboss.as.web.security.SecurityContextAssociationValve;
import org.jboss.as.web.security.WarJaccService;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.ContainerListenerMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ValveMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SecurityUtil;
import org.jboss.vfs.VirtualFile;

public class WarDeploymentProcessor
implements DeploymentUnitProcessor {
    private final String defaultHost;

    public WarDeploymentProcessor(String defaultHost) {
        if (defaultHost == null) {
            throw WebMessages.MESSAGES.nullDefaultHost();
        }
        this.defaultHost = defaultHost;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData metaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (metaData == null) {
            return;
        }
        String hostName = WarDeploymentProcessor.hostNameOfDeployment(metaData, this.defaultHost);
        this.processDeployment(hostName, metaData, deploymentUnit, phaseContext.getServiceTarget());
    }

    public static String hostNameOfDeployment(WarMetaData metaData, String defaultHost) {
        String hostName;
        Collection<Object> hostNames = null;
        if (metaData.getMergedJBossWebMetaData() != null) {
            hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        }
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(defaultHost);
        }
        if ((hostName = (String)hostNames.iterator().next()) == null) {
            throw WebMessages.MESSAGES.nullHostName();
        }
        return hostName;
    }

    public void undeploy(DeploymentUnit context) {
        WarSecurityDeployer deployer = new WarSecurityDeployer();
        deployer.undeploy(context);
    }

    protected void processDeployment(String hostName, WarMetaData warMetaData, DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.failedToResolveModule(deploymentRoot));
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        List setupActions = deploymentUnit.getAttachmentList(org.jboss.as.ee.component.Attachments.WEB_SETUP_ACTIONS);
        WebContextFactory contextFactory = (WebContextFactory)deploymentUnit.getAttachment(WebContextFactory.ATTACHMENT);
        if (contextFactory == null) {
            contextFactory = WebContextFactory.DEFAULT;
        }
        StandardContext webContext = contextFactory.createContext(deploymentUnit);
        JBossContextConfig config = new JBossContextConfig(deploymentUnit);
        webContext.addValve((Valve)new SecurityContextAssociationValve(deploymentUnit));
        try {
            webContext.setDocBase(deploymentRoot.getPhysicalFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        webContext.addLifecycleListener((LifecycleListener)config);
        String pathName = WarDeploymentProcessor.pathNameOfDeployment(deploymentUnit, metaData);
        webContext.setPath(pathName);
        webContext.setIgnoreAnnotations(true);
        webContext.setCrossContext(!metaData.isDisableCrossContext());
        contextFactory.postProcessContext(deploymentUnit, webContext);
        WebInjectionContainer injectionContainer = new WebInjectionContainer((ClassLoader)module.getClassLoader());
        Map components = (Map)deploymentUnit.getAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS);
        if (components != null) {
            Set failed = (Set)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.FAILED_COMPONENTS);
            for (Map.Entry entry : components.entrySet()) {
                boolean skip = false;
                for (ServiceName serviceName : ((ComponentInstantiator)entry.getValue()).getServiceNames()) {
                    if (!failed.contains(serviceName)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                injectionContainer.addInstantiator((String)entry.getKey(), (ComponentInstantiator)entry.getValue());
            }
        }
        WebCtxLoader loader = new WebCtxLoader((ClassLoader)classLoader);
        webContext.setLoader((Loader)loader);
        ArrayList valves = metaData.getValves();
        if (valves == null) {
            valves = new ArrayList();
            metaData.setValves(valves);
        }
        for (ValveMetaData valve : valves) {
            Valve valveInstance = (Valve)this.getInstance(module, valve.getModule(), valve.getValveClass(), valve.getParams());
            webContext.getPipeline().addValve(valveInstance);
        }
        List listeners = metaData.getContainerListeners();
        if (listeners != null) {
            for (ContainerListenerMetaData listener : listeners) {
                switch (listener.getListenerType()) {
                    case CONTAINER: {
                        ContainerListener containerListener = (ContainerListener)this.getInstance(module, listener.getModule(), listener.getListenerClass(), listener.getParams());
                        webContext.addContainerListener(containerListener);
                        break;
                    }
                    case LIFECYCLE: {
                        LifecycleListener lifecycleListener = (LifecycleListener)this.getInstance(module, listener.getModule(), listener.getListenerClass(), listener.getParams());
                        if (!(webContext instanceof Lifecycle)) break;
                        webContext.addLifecycleListener(lifecycleListener);
                        break;
                    }
                    case SERVLET_INSTANCE: {
                        webContext.addInstanceListener(listener.getListenerClass());
                        break;
                    }
                    case SERVLET_CONTAINER: {
                        webContext.addWrapperListener(listener.getListenerClass());
                        break;
                    }
                    case SERVLET_LIFECYCLE: {
                        webContext.addWrapperLifecycle(listener.getListenerClass());
                    }
                }
            }
        }
        switch (metaData.getSessionCookies()) {
            case 1: {
                webContext.setCookies(true);
                break;
            }
            case 2: {
                webContext.setCookies(false);
            }
        }
        String metaDataSecurityDomain = metaData.getSecurityDomain();
        if (metaDataSecurityDomain == null) {
            metaDataSecurityDomain = this.getJBossAppSecurityDomain(deploymentUnit);
        }
        if (metaDataSecurityDomain != null) {
            metaDataSecurityDomain = metaDataSecurityDomain.trim();
        }
        String securityDomain = metaDataSecurityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain);
        List attributes = (List)deploymentUnit.getAttachment(ServletContextAttribute.ATTACHMENT_KEY);
        try {
            DistributedCacheManagerFactoryService factoryService;
            DistributedCacheManagerFactory factory;
            ServiceName deploymentServiceName = WebSubsystemServices.deploymentServiceName(hostName, pathName);
            ServiceName realmServiceName = deploymentServiceName.append(new String[]{"realm"});
            JBossWebRealmService realmService = new JBossWebRealmService(deploymentUnit);
            ServiceBuilder builder = serviceTarget.addService(realmServiceName, (Service)realmService);
            builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}), SecurityDomainContext.class, realmService.getSecurityDomainContextInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            WebDeploymentService webDeploymentService = new WebDeploymentService(webContext, injectionContainer, setupActions, attributes);
            builder = serviceTarget.addService(deploymentServiceName, (Service)webDeploymentService).addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName}), VirtualHost.class, (Injector)new WebContextInjector((Context)webContext)).addDependencies(injectionContainer.getServiceNames()).addDependency(realmServiceName, Realm.class, webDeploymentService.getRealm()).addDependencies((Iterable)deploymentUnit.getAttachmentList(Attachments.WEB_DEPENDENCIES)).addDependency(JndiNamingDependencyProcessor.serviceName((DeploymentUnit)deploymentUnit));
            for (SetupAction action : setupActions) {
                builder.addDependencies((Iterable)action.dependencies());
            }
            if (metaData.getDistributable() != null && (factory = (factoryService = new DistributedCacheManagerFactoryService()).getValue()) != null) {
                ServiceName factoryServiceName = deploymentServiceName.append(new String[]{"session"});
                builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, factoryServiceName, DistributedCacheManagerFactory.class, config.getDistributedCacheManagerFactoryInjector());
                ServiceBuilder factoryBuilder = serviceTarget.addService(factoryServiceName, (Service)factoryService);
                boolean enabled = factory.addDeploymentDependencies(deploymentServiceName, deploymentUnit.getServiceRegistry(), serviceTarget, factoryBuilder, metaData);
                factoryBuilder.setInitialMode(enabled ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.NEVER).install();
            }
            builder.install();
            WarSecurityDeployer deployer = new WarSecurityDeployer();
            JaccService service = deployer.deploy(deploymentUnit);
            if (service != null) {
                ((WarJaccService)service).setContext((Context)webContext);
                ServiceName jaccServiceName = deploymentUnit.getServiceName().append(JaccService.SERVICE_NAME);
                builder = serviceTarget.addService(jaccServiceName, (Service)service);
                if (deploymentUnit.getParent() != null) {
                    DeploymentUnit parentDU = deploymentUnit.getParent();
                    builder.addDependency(parentDU.getServiceName().append(JaccService.SERVICE_NAME), PolicyConfiguration.class, service.getParentPolicyInjector());
                }
                builder.addDependency(deploymentServiceName);
                builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
        catch (ServiceRegistryException e) {
            throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.failedToAddWebDeployment(), (Throwable)e);
        }
        ModelNode node = deploymentUnit.getDeploymentSubsystemModel("web");
        node.get(WebDeploymentDefinition.CONTEXT_ROOT.getName()).set("".equals(pathName) ? "/" : pathName);
        node.get(WebDeploymentDefinition.VIRTUAL_HOST.getName()).set(hostName);
        this.processManagement(deploymentUnit, metaData);
    }

    public static String pathNameOfDeployment(DeploymentUnit deploymentUnit, JBossWebMetaData metaData) {
        String pathName;
        if (metaData.getContextRoot() == null) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            pathName = description != null ? "/" + description.getModuleName() : "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if ("/".equals(pathName)) {
                pathName = "";
            } else if (pathName.length() > 0 && pathName.charAt(0) != '/') {
                pathName = "/" + pathName;
            }
        }
        return pathName;
    }

    void processManagement(DeploymentUnit unit, JBossWebMetaData metaData) {
        for (JBossServletMetaData servlet : metaData.getServlets()) {
            try {
                String name = servlet.getName().replace(' ', '_');
                ModelNode node = unit.createDeploymentSubModel("web", PathElement.pathElement((String)"servlet", (String)name));
                node.get("servlet-class").set(servlet.getServletClass());
                node.get("servlet-name").set(servlet.getServletName());
            }
            catch (Exception e) {}
        }
    }

    protected Object getInstance(Module module, String moduleName, String className, List<ParamValueMetaData> params) throws DeploymentUnitProcessingException {
        try {
            ModuleClassLoader moduleClassLoader = null;
            moduleClassLoader = moduleName == null ? module.getClassLoader() : module.getModule(ModuleIdentifier.create((String)moduleName)).getClassLoader();
            Object instance = moduleClassLoader.loadClass(className).newInstance();
            if (params != null) {
                for (ParamValueMetaData param : params) {
                    IntrospectionUtils.setProperty(instance, (String)param.getParamName(), (String)param.getParamValue());
                }
            }
            return instance;
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.failToCreateContainerComponentInstance(className), t);
        }
    }

    private String getJBossAppSecurityDomain(DeploymentUnit deploymentUnit) {
        EarMetaData jbossAppMetaData;
        String securityDomain = null;
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent != null && (jbossAppMetaData = (EarMetaData)parent.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA)) instanceof JBossAppMetaData) {
            securityDomain = ((JBossAppMetaData)jbossAppMetaData).getSecurityDomain();
        }
        return securityDomain;
    }
}

