/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;

public final class WSEJBAdapterDeployer {
    private static final Logger LOGGER = Logger.getLogger(WSEJBAdapterDeployer.class);
    private static final DotName WEB_SERVICE_ANNOTATION = DotName.createSimple((String)WebService.class.getName());
    private static final DotName WEB_SERVICE_PROVIDER_ANNOTATION = DotName.createSimple((String)WebServiceProvider.class.getName());

    public static void internalDeploy(DeploymentUnit unit) {
        WebServiceDeploymentAdapter wsDeploymentAdapter = new WebServiceDeploymentAdapter();
        WSEJBAdapterDeployer.processAnnotation(unit, WEB_SERVICE_ANNOTATION, wsDeploymentAdapter);
        WSEJBAdapterDeployer.processAnnotation(unit, WEB_SERVICE_PROVIDER_ANNOTATION, wsDeploymentAdapter);
        unit.putAttachment(WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY, (Object)wsDeploymentAdapter);
    }

    private static void processAnnotation(DeploymentUnit unit, DotName annotation, WebServiceDeploymentAdapter wsDeploymentAdapter) {
        List<AnnotationInstance> webServiceAnnotations = WSEJBAdapterDeployer.getAnnotations(unit, annotation);
        List<WebServiceDeclaration> endpoints = wsDeploymentAdapter.getServiceEndpoints();
        if (webServiceAnnotations != null && !webServiceAnnotations.isEmpty()) {
            EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            for (AnnotationInstance webServiceAnnotation : webServiceAnnotations) {
                AnnotationTarget target = webServiceAnnotation.target();
                ClassInfo webServiceClassInfo = (ClassInfo)target;
                String beanClassName = webServiceClassInfo.name().toString();
                ComponentDescription absCD = moduleDescription.getComponentByClassName(beanClassName);
                String componentName = beanClassName.substring(beanClassName.lastIndexOf(".") + 1);
                ServiceName baseName = unit.getServiceName().append(new String[]{"component"}).append(new String[]{componentName}).append(new String[]{"START"});
                if (!(absCD instanceof StatelessComponentDescription) && !(absCD instanceof SingletonComponentDescription)) continue;
                String ejbContainerName = WSEJBAdapterDeployer.newEJBContainerName(unit, absCD);
                endpoints.add(new WebServiceDeclarationAdapter((SessionBeanComponentDescription)absCD, webServiceClassInfo, ejbContainerName));
            }
        }
    }

    private static String newEJBContainerName(DeploymentUnit unit, ComponentDescription componentDescription) {
        return unit.getServiceName().append(new String[]{"component"}).append(new String[]{componentDescription.getComponentName()}).append(new String[]{"START"}).getCanonicalName();
    }

    private static List<AnnotationInstance> getAnnotations(DeploymentUnit unit, DotName annotation) {
        Index compositeIndex = ASHelper.getRootAnnotationIndex(unit);
        return compositeIndex.getAnnotations(annotation);
    }

    private static final class WebServiceDeploymentAdapter
    implements WebServiceDeployment {
        private final List<WebServiceDeclaration> endpoints = new ArrayList<WebServiceDeclaration>();

        private WebServiceDeploymentAdapter() {
        }

        public List<WebServiceDeclaration> getServiceEndpoints() {
            return this.endpoints;
        }
    }

    private static final class WebServiceDeclarationAdapter
    implements WebServiceDeclaration {
        private final SessionBeanComponentDescription ejbMD;
        private final ClassInfo webServiceClassInfo;
        private final String containerName;

        private WebServiceDeclarationAdapter(SessionBeanComponentDescription ejbMD, ClassInfo webServiceClassInfo, String containerName) {
            this.ejbMD = ejbMD;
            this.webServiceClassInfo = webServiceClassInfo;
            this.containerName = containerName;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public String getComponentName() {
            return this.ejbMD.getComponentName();
        }

        public String getComponentClassName() {
            return this.ejbMD.getComponentClassName();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            throw new UnsupportedOperationException();
        }
    }
}

