/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr.management;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

abstract class WSAbstractOperationHandler
implements OperationHandler {
    private static final OperationResult RESULT = new BasicOperationResult();

    protected WSAbstractOperationHandler() {
    }

    public final OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(WSServices.REGISTRY_SERVICE);
                    if (controller != null) {
                        try {
                            ModelNode result = WSAbstractOperationHandler.this.getManagementOperationResultFragment(operation, controller);
                            resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, result);
                            resultHandler.handleResultComplete();
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(new ModelNode().set(WSAbstractOperationHandler.this.getFallbackMessage() + ": " + e.getMessage()));
                        }
                    } else {
                        WSAbstractOperationHandler.fallback(resultHandler, WSAbstractOperationHandler.this.getFallbackMessage());
                    }
                }
            });
        } else {
            WSAbstractOperationHandler.fallback(resultHandler, this.getFallbackMessage());
        }
        return RESULT;
    }

    protected abstract String getFallbackMessage();

    protected abstract ModelNode getManagementOperationResultFragment(ModelNode var1, ServiceController<?> var2) throws OperationFailedException;

    private static void fallback(ResultHandler resultHandler, String msg) {
        ModelNode fallbackFragmenet = new ModelNode().set(msg);
        resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, fallbackFragmenet);
        resultHandler.handleResultComplete();
    }
}

