/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.Services;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class ModelUpdateService
extends AbstractService<Void> {
    private final InjectedValue<ServerController> serverControllerValue = new InjectedValue();
    private static final ModelUpdateService INSTANCE = new ModelUpdateService();

    private ModelUpdateService() {
    }

    private InjectedValue<ServerController> getServerControllerInjector() {
        return this.serverControllerValue;
    }

    public static ModelUpdateService getInstance() {
        return INSTANCE;
    }

    public static void install(ServiceTarget serviceTarget) {
        InjectedValue<ServerController> controllerInjector = INSTANCE.getServerControllerInjector();
        ServiceBuilder builder = serviceTarget.addService(WSServices.MODEL_SERVICE, (Service)INSTANCE);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, Services.JBOSS_SERVER_CONTROLLER, ServerController.class, controllerInjector);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    public void add(Endpoint endpoint) {
        ServerController controller = (ServerController)this.serverControllerValue.getOptionalValue();
        if (controller != null) {
            Operation addOperation = this.newAddOperation(endpoint);
            controller.execute(addOperation);
        }
    }

    public void remove(Endpoint endpoint) {
        ServerController controller = (ServerController)this.serverControllerValue.getOptionalValue();
        if (controller != null) {
            Operation removeOperation = this.newRemoveOperation(endpoint);
            controller.execute(removeOperation);
        }
    }

    private Operation newAddOperation(Endpoint endpoint) {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        ModelNode address = op.get("address");
        address.add("subsystem", "webservices");
        address.add("endpoint", this.getId(endpoint));
        op.get("name").set(this.getName(endpoint));
        op.get("context").set(this.getContext(endpoint));
        op.get("class").set(endpoint.getTargetBeanName());
        op.get("type").set(this.getType(endpoint));
        op.get("wsdl-url").set(endpoint.getAddress() + "?wsdl");
        return OperationBuilder.Factory.create((ModelNode)op).build();
    }

    private Operation newRemoveOperation(Endpoint endpoint) {
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        ModelNode address = op.get("address");
        address.add("subsystem", "webservices");
        address.add("endpoint", this.getId(endpoint));
        return OperationBuilder.Factory.create((ModelNode)op).build();
    }

    private String getType(Endpoint endpoint) {
        return endpoint.getService().getDeployment().getType().toString();
    }

    private String getName(Endpoint endpoint) {
        return endpoint.getName().getKeyProperty("endpoint");
    }

    private String getContext(Endpoint endpoint) {
        return endpoint.getName().getKeyProperty("context");
    }

    private String getId(Endpoint endpoint) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getContext(endpoint));
        sb.append(':');
        sb.append(this.getName(endpoint));
        return sb.toString();
    }
}

