/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.weld.CurrentServiceRegistry;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.ejb.api.SessionObjectReference;

public class SessionObjectReferenceImpl
implements SessionObjectReference {
    private volatile boolean removed = false;
    private final Map<String, ServiceName> viewServices;

    public SessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor, ServiceRegistry serviceRegistry) {
        ServiceName createServiceName = descriptor.getCreateServiceName();
        ServiceController controller = serviceRegistry.getRequiredService(createServiceName);
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (ViewDescription view : descriptor.getComponentDescription().getViews()) {
            viewServices.put(view.getViewClassName(), view.getServiceName());
        }
        this.viewServices = viewServices;
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        if (this.removed) {
            return null;
        }
        if (this.viewServices.containsKey(businessInterfaceType.getName())) {
            ServiceController serviceController = CurrentServiceRegistry.getServiceRegistry().getRequiredService(this.viewServices.get(businessInterfaceType.getName()));
            ComponentView view = (ComponentView)serviceController.getValue();
            ComponentViewInstance instance = view.createInstance();
            return (S)instance.createProxy();
        }
        throw new IllegalArgumentException("View of type " + businessInterfaceType + " not found on bean ");
    }

    public void remove() {
    }

    public boolean isRemoved() {
        return false;
    }
}

