/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.weld.injection.SecurityActions;
import org.jboss.as.weld.injection.WeldEEInjection;
import org.jboss.as.weld.injection.WeldManagedReference;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldManagedReferenceFactory
implements ManagedReferenceFactory,
Service<WeldManagedReferenceFactory> {
    private final Class<?> componentClass;
    private final InjectedValue<BeanManagerImpl> beanManager;
    private final String ejbName;
    private final Set<Class<?>> interceptorClasses;
    private final Map<Class<?>, WeldEEInjection> interceptorInjections = new HashMap();
    private final ClassLoader classLoader;
    private volatile WeldEEInjection injectionTarget;
    private volatile Bean<?> bean;

    public WeldManagedReferenceFactory(Class<?> componentClass, String ejbName, Set<Class<?>> interceptorClasses, ClassLoader classLoader) {
        this.componentClass = componentClass;
        this.ejbName = ejbName;
        this.beanManager = new InjectedValue();
        this.interceptorClasses = interceptorClasses;
        this.classLoader = classLoader;
    }

    public ManagedReference getReference() {
        BeanManagerImpl beanManager = (BeanManagerImpl)this.beanManager.getValue();
        WeldCreationalContext ctx = this.bean == null ? beanManager.createCreationalContext(null) : beanManager.createCreationalContext(this.bean);
        Object instance = this.injectionTarget.produce((CreationalContext<?>)ctx);
        return new WeldManagedReference((CreationalContext<?>)ctx, instance, this.injectionTarget, this.interceptorInjections);
    }

    public ManagedReference injectExistingReference(final ManagedReference existing) {
        BeanManagerImpl beanManager = (BeanManagerImpl)this.beanManager.getValue();
        WeldCreationalContext ctx = this.bean == null ? beanManager.createCreationalContext(null) : beanManager.createCreationalContext(this.bean);
        Object instance = existing.getInstance();
        this.injectionTarget.inject(instance, (CreationalContext<?>)ctx);
        return new ManagedReference((CreationalContext)ctx, instance){
            final /* synthetic */ CreationalContext val$ctx;
            final /* synthetic */ Object val$instance;
            {
                this.val$ctx = creationalContext;
                this.val$instance = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void release() {
                try {
                    existing.release();
                }
                finally {
                    this.val$ctx.release();
                }
            }

            public Object getInstance() {
                return this.val$instance;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ClassLoader cl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(this.classLoader);
            BeanManagerImpl beanManager = (BeanManagerImpl)this.beanManager.getValue();
            for (Class<?> interceptor : this.interceptorClasses) {
                this.interceptorInjections.put(interceptor, WeldEEInjection.createWeldEEInjection(interceptor, null, beanManager));
            }
            if (this.ejbName != null) {
                EjbDescriptor descriptor = beanManager.getEjbDescriptor(this.ejbName);
                this.bean = beanManager.getBean(descriptor);
            }
            this.injectionTarget = WeldEEInjection.createWeldEEInjection(this.componentClass, this.bean, beanManager);
        }
        finally {
            SecurityActions.setContextClassLoader(cl);
        }
    }

    public void stop(StopContext context) {
        this.injectionTarget = null;
        this.interceptorInjections.clear();
        this.bean = null;
    }

    public WeldManagedReferenceFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<BeanManagerImpl> getBeanManager() {
        return this.beanManager;
    }
}

