/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jboss.as.plugin.server.Server;

final class SecurityActions {
    SecurityActions() {
    }

    static void respawnCurrentClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!(classLoader instanceof ClassRealm)) {
            return;
        }
        final ClassRealm classRealm = (ClassRealm)classLoader;
        URLClassLoader newClassLoader = new URLClassLoader(classRealm.getURLs(), classRealm.getParentClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> clazz = classRealm.loadClassFromSelf(name);
                return clazz != null ? clazz : super.loadClass(name, resolve);
            }
        };
        classRealm.setParentClassLoader((ClassLoader)newClassLoader);
    }

    static void registerShutdown(final Server server) {
        Thread hook = new Thread(new Runnable(){

            @Override
            public void run() {
                SecurityActions.respawnCurrentClassLoader();
                server.stop();
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        hook.setDaemon(true);
        SecurityActions.addShutdownHook(hook);
    }

    static void addShutdownHook(final Thread hook) {
        if (System.getSecurityManager() == null) {
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        }
    }

    static String getEnvironmentVariable(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getenv(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(key);
            }
        });
    }
}

