/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.model.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import lombok.NonNull;
import org.jboss.da.model.rest.DummyVersionComparator;
import org.jboss.da.model.rest.GA;

@JsonPropertyOrder(value={"groupId", "artifactId", "version"})
public class GAV
implements Comparable<GAV> {
    @NonNull
    private final GA ga;
    @NonNull
    private final String version;

    @JsonCreator
    public GAV(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId, @JsonProperty(value="version") String version) {
        this.ga = new GA(groupId, artifactId);
        this.version = Objects.requireNonNull(version);
    }

    @JsonIgnore
    public GA getGA() {
        return this.ga;
    }

    public String getGroupId() {
        return this.ga.getGroupId();
    }

    public String getArtifactId() {
        return this.ga.getArtifactId();
    }

    public String toString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    @Override
    public int compareTo(GAV o) {
        int gaCmp = this.ga.compareTo(o.ga);
        if (gaCmp == 0) {
            return DummyVersionComparator.compareVersions(this.version, o.version);
        }
        return gaCmp;
    }

    public GAV(@NonNull GA ga, @NonNull String version) {
        if (ga == null) {
            throw new NullPointerException("ga is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.ga = ga;
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GAV)) {
            return false;
        }
        GAV other = (GAV)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GA this$ga = this.getGA();
        GA other$ga = other.getGA();
        if (this$ga == null ? other$ga != null : !((Object)this$ga).equals(other$ga)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GAV;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GA $ga = this.getGA();
        result = result * 59 + ($ga == null ? 43 : ((Object)$ga).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }
}

