/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.reports.model.response;

import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import lombok.NonNull;
import org.jboss.da.listings.model.rest.RestProductInput;
import org.jboss.da.model.rest.GAV;

@JsonRootName(value="report")
public class Report {
    @NonNull
    private final String groupId;
    @NonNull
    private final String artifactId;
    @NonNull
    private final String version;
    @NonNull
    private final List<String> availableVersions;
    private final String bestMatchVersion;
    private final boolean dependencyVersionsSatisfied;
    @NonNull
    private final List<Report> dependencies;
    private final boolean blacklisted;
    private final List<RestProductInput> whitelisted;
    private final int notBuiltDependencies;

    public Report(GAV gav, List<String> availableVersions, String bestMatchVersion, boolean dependencyVersionsSatisfied, List<Report> dependencies, boolean blacklisted, List<RestProductInput> whitelisted, int notBuiltDependencies) {
        this(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), availableVersions, bestMatchVersion, dependencyVersionsSatisfied, dependencies, blacklisted, whitelisted, notBuiltDependencies);
    }

    public Report(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, @NonNull List<String> availableVersions, String bestMatchVersion, boolean dependencyVersionsSatisfied, @NonNull List<Report> dependencies, boolean blacklisted, List<RestProductInput> whitelisted, int notBuiltDependencies) {
        if (groupId == null) {
            throw new NullPointerException("groupId is marked non-null but is null");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (availableVersions == null) {
            throw new NullPointerException("availableVersions is marked non-null but is null");
        }
        if (dependencies == null) {
            throw new NullPointerException("dependencies is marked non-null but is null");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.availableVersions = availableVersions;
        this.bestMatchVersion = bestMatchVersion;
        this.dependencyVersionsSatisfied = dependencyVersionsSatisfied;
        this.dependencies = dependencies;
        this.blacklisted = blacklisted;
        this.whitelisted = whitelisted;
        this.notBuiltDependencies = notBuiltDependencies;
    }

    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    @NonNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public List<String> getAvailableVersions() {
        return this.availableVersions;
    }

    public String getBestMatchVersion() {
        return this.bestMatchVersion;
    }

    public boolean isDependencyVersionsSatisfied() {
        return this.dependencyVersionsSatisfied;
    }

    @NonNull
    public List<Report> getDependencies() {
        return this.dependencies;
    }

    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public List<RestProductInput> getWhitelisted() {
        return this.whitelisted;
    }

    public int getNotBuiltDependencies() {
        return this.notBuiltDependencies;
    }
}

