/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.timerservice.naming;

import java.util.Hashtable;

import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;

import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.spi.BeanManager;
import org.jboss.ejb3.context.spi.EJBContext;


/**
 * An implementation of {@link ObjectFactory} which is responsible for returing
 * a {@link TimerService} for the current {@link EJBContext}
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public class TimerServiceObjectFactory implements ObjectFactory
{

   /**
    * Returns {@link TimerService} for the current {@link EJBContext}
    */
   @Override
   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment)
         throws Exception
   {
      // get hold of EJBContext
      EJBContext currentEJBContext = CurrentInvocationContext.get().getEJBContext();
      // now get hold of the BeanManager from the EJBContext.
      // Note that we could have directly used EJBContext.getTimerService(), but that
      // won't work in all cases, because the EJBContext.getTimerService() is an user API
      // and the spec mandates that this API throw an exception when invoked during injection.
      // Internal implementation (like injectors) of EJB3 will require to get hold of the
      // TimerService during injection (to actually do the injection). Hence we bypass the user
      // API and instead use the BeanManager.getTimerService() which doesn't have a restriction
      // on using it during injection.
      BeanManager beanManager =  currentEJBContext.getManager();
      // now finally get hold of the timerservice
      return beanManager.getTimerService();
   }

}
