/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.scaffold.faces;

import freemarker.template.Template;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.javaee.cdi.CDIFacet;
import org.jboss.forge.addon.javaee.cdi.ui.CDISetupCommand;
import org.jboss.forge.addon.javaee.ejb.EJBFacet;
import org.jboss.forge.addon.javaee.ejb.ui.EJBSetupWizard;
import org.jboss.forge.addon.javaee.faces.FacesFacet;
import org.jboss.forge.addon.javaee.faces.ui.FacesSetupWizard;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupWizard;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.javaee.servlet.ServletFacet_3_0;
import org.jboss.forge.addon.javaee.servlet.ServletFacet_3_1;
import org.jboss.forge.addon.javaee.servlet.ui.ServletSetupWizard;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.scaffold.faces.FacesAccessStrategy;
import org.jboss.forge.addon.scaffold.faces.FacesTemplateStrategy;
import org.jboss.forge.addon.scaffold.faces.ScaffoldableEntitySelectionWizard;
import org.jboss.forge.addon.scaffold.faces.TemplateStrategy;
import org.jboss.forge.addon.scaffold.faces.freemarker.FreemarkerTemplateProcessor;
import org.jboss.forge.addon.scaffold.faces.metawidget.config.ForgeConfigReader;
import org.jboss.forge.addon.scaffold.spi.AccessStrategy;
import org.jboss.forge.addon.scaffold.spi.ScaffoldGenerationContext;
import org.jboss.forge.addon.scaffold.spi.ScaffoldProvider;
import org.jboss.forge.addon.scaffold.spi.ScaffoldSetupContext;
import org.jboss.forge.addon.scaffold.ui.ScaffoldSetupWizard;
import org.jboss.forge.addon.scaffold.util.ScaffoldUtil;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MemberSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.util.Types;
import org.jboss.shrinkwrap.descriptor.api.javaee.ParamValueCommonType;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp.WebAppCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon.ErrorPageCommonType;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.WelcomeFileListType;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptor;
import org.metawidget.config.iface.ConfigReader;
import org.metawidget.statically.StaticUtils;
import org.metawidget.statically.faces.StaticFacesUtils;
import org.metawidget.statically.faces.component.html.StaticHtmlMetawidget;
import org.metawidget.statically.faces.component.html.widgetbuilder.HtmlOutcomeTargetLink;
import org.metawidget.statically.html.widgetbuilder.HtmlTag;
import org.metawidget.statically.javacode.StaticJavaMetawidget;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class FacesScaffoldProvider
implements ScaffoldProvider {
    private static final String JBOSS_COMMUNITY_PNG = "/resources/jboss-community.png";
    private static final String SCAFFOLD_JBOSS_COMMUNITY_PNG = "/scaffold/faces/jboss-community.png";
    private static final String TRUE_PNG = "/resources/true.png";
    private static final String SCAFFOLD_TRUE_PNG = "/scaffold/faces/true.png";
    private static final String SEARCH_PNG = "/resources/search.png";
    private static final String SCAFFOLD_SEARCH_PNG = "/scaffold/faces/search.png";
    private static final String REMOVE_PNG = "/resources/remove.png";
    private static final String SCAFFOLD_REMOVE_PNG = "/scaffold/faces/remove.png";
    private static final String FORGE_STYLE_CSS = "/resources/forge-style.css";
    private static final String SCAFFOLD_FORGE_STYLE_CSS = "/scaffold/faces/forge-style.css";
    private static final String FORGE_LOGO_PNG = "/resources/forge-logo.png";
    private static final String SCAFFOLD_FORGE_LOGO_PNG = "/scaffold/faces/forge-logo.png";
    private static final String FAVICON_ICO = "/resources/favicon.ico";
    private static final String SCAFFOLD_FAVICON_ICO = "/scaffold/faces/favicon.ico";
    private static final String FALSE_PNG = "/resources/false.png";
    private static final String SCAFFOLD_FALSE_PNG = "/scaffold/faces/false.png";
    private static final String BOOTSTRAP_CSS = "/resources/bootstrap.css";
    private static final String SCAFFOLD_BOOTSTRAP_CSS = "/scaffold/faces/bootstrap.css";
    private static final String ADD_PNG = "/resources/add.png";
    private static final String SCAFFOLD_ADD_PNG = "/scaffold/faces/add.png";
    private static final String ERROR_XHTML = "error.xhtml";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String BACKING_BEAN_TEMPLATE = "scaffold/faces/BackingBean.jv";
    private static final String VIEW_UTILS_TEMPLATE = "scaffold/faces/ViewUtils.jv";
    private static final String TAGLIB_TEMPLATE = "scaffold/faces/forge.taglib.xml";
    private static final String VIEW_TEMPLATE = "scaffold/faces/view.xhtml";
    private static final String CREATE_TEMPLATE = "scaffold/faces/create.xhtml";
    private static final String SEARCH_TEMPLATE = "scaffold/faces/search.xhtml";
    private static final String NAVIGATION_TEMPLATE = "scaffold/faces/pageTemplate.xhtml";
    private static final String SCAFFOLD_NAVIGATION_TEMPLATE = "/resources/scaffold/pageTemplate.xhtml";
    private static final String ERROR_TEMPLATE = "scaffold/faces/error.xhtml";
    private static final String INDEX_TEMPLATE = "scaffold/faces/index.xhtml";
    private static final String INDEX_HTML_TEMPLATE = "scaffold/faces/index.html";
    private static final String INDEX_XHTML = "/index.xhtml";
    private static final String INDEX_HTML = "/index.html";
    private static final String SCAFFOLD_META_WIDGET_REMOVE_ENTITY = "scaffold/faces/metawidget-remove-entity.xml";
    private static final String SCAFFOLD_META_WIDGET_ENTITY = "scaffold/faces/metawidget-entity.xml";
    private static final String SCAFFOLD_META_WIDGET_SEARCH = "scaffold/faces/metawidget-search.xml";
    private static final String SCAFFOLD_META_WIDGET_BEAN = "scaffold/faces/metawidget-bean.xml";
    private static final String SCAFFOLD_META_WIDGET_QBE = "scaffold/faces/metawidget-qbe.xml";
    private static final String PAGINATOR = "/resources/scaffold/paginator.xhtml";
    private static final String SCAFFOLD_PAGINATOR = "/scaffold/faces/paginator.xhtml";
    protected Template backingBeanTemplate;
    protected int backingBeanTemplateQbeMetawidgetIndent;
    protected int backingBeanTemplateRmEntityMetawidgetIndent;
    protected Template viewUtilsTemplate;
    protected Template taglibTemplate;
    protected Template viewTemplate;
    protected Map<String, String> viewTemplateNamespaces;
    protected int viewTemplateEntityMetawidgetIndent;
    protected Template createTemplate;
    protected Map<String, String> createTemplateNamespaces;
    protected int createTemplateEntityMetawidgetIndent;
    protected Template searchTemplate;
    protected Map<String, String> searchTemplateNamespaces;
    protected int searchTemplateSearchMetawidgetIndent;
    protected int searchTemplateBeanMetawidgetIndent;
    protected Template navigationTemplate;
    protected int navigationTemplateIndent;
    protected Template errorTemplate;
    protected Template indexWelcomeTemplate;
    protected Template indexTemplate;
    protected StaticHtmlMetawidget entityMetawidget;
    protected StaticHtmlMetawidget searchMetawidget;
    protected StaticHtmlMetawidget beanMetawidget;
    protected StaticJavaMetawidget qbeMetawidget;
    protected StaticJavaMetawidget rmEntityMetawidget;
    private Project project;

    private void setProject(Project project) {
        this.project = project;
        this.resetMetaWidgets();
    }

    public String getName() {
        return "Faces";
    }

    public String getDescription() {
        return "Scaffold a Faces project from JPA entities";
    }

    public List<Resource<?>> setup(ScaffoldSetupContext setupContext) {
        this.setProject(setupContext.getProject());
        String targetDir = setupContext.getTargetDirectory();
        Resource<?> template = null;
        List<Resource<?>> resources = this.generateIndex(targetDir, template);
        this.setupWebXML();
        return resources;
    }

    public boolean isSetup(ScaffoldSetupContext setupContext) {
        Project project = setupContext.getProject();
        this.setProject(project);
        String targetDir = setupContext.getTargetDirectory();
        String string = targetDir = targetDir == null ? "" : targetDir;
        if (project.hasAllFacets(Arrays.asList(WebResourcesFacet.class, DependencyFacet.class, JPAFacet.class, EJBFacet.class, CDIFacet.class, ServletFacet.class, FacesFacet.class))) {
            WebResourcesFacet web = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
            boolean areResourcesInstalled = web.getWebResource(targetDir + INDEX_HTML).exists() && web.getWebResource(targetDir + INDEX_XHTML).exists() && web.getWebResource(ERROR_XHTML).exists() && web.getWebResource(ADD_PNG).exists() && web.getWebResource(BOOTSTRAP_CSS).exists() && web.getWebResource(FALSE_PNG).exists() && web.getWebResource(FAVICON_ICO).exists() && web.getWebResource(FORGE_LOGO_PNG).exists() && web.getWebResource(FORGE_STYLE_CSS).exists() && web.getWebResource(REMOVE_PNG).exists() && web.getWebResource(SEARCH_PNG).exists() && web.getWebResource(TRUE_PNG).exists() && web.getWebResource(JBOSS_COMMUNITY_PNG).exists() && web.getWebResource(PAGINATOR).exists() && this.getTemplateStrategy().getDefaultTemplate().exists();
            ServletFacet servlet = (ServletFacet)project.getFacet(ServletFacet.class);
            boolean isWelcomeFileListed = false;
            if (servlet instanceof ServletFacet_3_0) {
                org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor servletConfig = (org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor)servlet.getConfig();
                block0: for (WelcomeFileListType welcomeFileList : servletConfig.getAllWelcomeFileList()) {
                    for (String welcomeFile : welcomeFileList.getAllWelcomeFile()) {
                        if (!welcomeFile.equals(INDEX_HTML)) continue;
                        isWelcomeFileListed = true;
                        continue block0;
                    }
                }
            } else if (servlet instanceof ServletFacet_3_1) {
                WebAppDescriptor servletConfig = (WebAppDescriptor)servlet.getConfig();
                block2: for (org.jboss.shrinkwrap.descriptor.api.webcommon31.WelcomeFileListType welcomeFileList : servletConfig.getAllWelcomeFileList()) {
                    for (String welcomeFile : welcomeFileList.getAllWelcomeFile()) {
                        if (!welcomeFile.equals(INDEX_HTML)) continue;
                        isWelcomeFileListed = true;
                        continue block2;
                    }
                }
            }
            return areResourcesInstalled && isWelcomeFileListed;
        }
        return false;
    }

    public List<Resource<?>> generateFrom(ScaffoldGenerationContext generationContext) {
        this.setProject(generationContext.getProject());
        ArrayList generatedResources = new ArrayList();
        Collection resources = generationContext.getResources();
        for (Object resource : resources) {
            JavaSource javaSource = null;
            if (!(resource instanceof JavaResource)) continue;
            JavaResource javaResource = (JavaResource)resource;
            try {
                javaSource = (JavaSource)javaResource.getJavaType();
            }
            catch (FileNotFoundException fileEx) {
                throw new IllegalStateException(fileEx);
            }
            JavaClassSource entity = (JavaClassSource)javaSource;
            String targetDir = generationContext.getTargetDirectory();
            targetDir = targetDir == null ? "" : targetDir;
            this.getConfig().setProperty(FacesScaffoldProvider.class.getName() + "_targetDir", (Object)targetDir);
            Resource template = (Resource)generationContext.getAttribute("pageTemplate");
            List<Resource<?>> generatedResourcesForEntity = this.generateFromEntity(targetDir, template, entity);
            generatedResources.addAll(generatedResourcesForEntity);
        }
        return generatedResources;
    }

    public NavigationResult getSetupFlow(ScaffoldSetupContext setupContext) {
        Project project = setupContext.getProject();
        this.setProject(setupContext.getProject());
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        ArrayList<Class> setupCommands = new ArrayList<Class>();
        if (!project.hasFacet(JPAFacet.class)) {
            builder.add(JPASetupWizard.class);
        }
        if (!project.hasFacet(CDIFacet.class)) {
            setupCommands.add(CDISetupCommand.class);
        }
        if (!project.hasFacet(EJBFacet.class)) {
            setupCommands.add(EJBSetupWizard.class);
        }
        if (!project.hasFacet(ServletFacet.class)) {
            setupCommands.add(ServletSetupWizard.class);
        }
        if (!project.hasFacet(FacesFacet.class)) {
            setupCommands.add(FacesSetupWizard.class);
        }
        Metadata compositeSetupMetadata = Metadata.forCommand(ScaffoldSetupWizard.class).name("Setup Facets").description("Setup all dependent facets for the Faces scaffold.");
        builder.add((UICommandMetadata)compositeSetupMetadata, setupCommands);
        return builder.build();
    }

    public NavigationResult getGenerationFlow(ScaffoldGenerationContext generationContext) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        builder.add(ScaffoldableEntitySelectionWizard.class);
        return builder.build();
    }

    protected List<Resource<?>> generateIndex(String targetDir, Resource<?> template) {
        org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor servletConfig;
        ArrayList result = new ArrayList();
        WebResourcesFacet web = (WebResourcesFacet)this.project.getFacet(WebResourcesFacet.class);
        ServletFacet servlet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        if (servlet instanceof ServletFacet_3_0) {
            servletConfig = (org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor)servlet.getConfig();
            servletConfig.getOrCreateWelcomeFileList().welcomeFile(new String[]{INDEX_HTML});
        } else if (servlet instanceof ServletFacet_3_1) {
            servletConfig = (WebAppDescriptor)servlet.getConfig();
            servletConfig.getOrCreateWelcomeFileList().welcomeFile(new String[]{INDEX_HTML});
        }
        this.loadTemplates();
        this.generateTemplates(targetDir);
        HashMap<Object, Object> context = this.getTemplateContext(targetDir, template);
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(targetDir + INDEX_HTML), (String)FreemarkerTemplateProcessor.processTemplate(context, this.indexWelcomeTemplate)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(targetDir + INDEX_XHTML), (String)FreemarkerTemplateProcessor.processTemplate(context, this.indexTemplate)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(ERROR_XHTML), (String)FreemarkerTemplateProcessor.processTemplate(context, this.errorTemplate)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(ADD_PNG), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_ADD_PNG)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(BOOTSTRAP_CSS), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_BOOTSTRAP_CSS)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(FALSE_PNG), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_FALSE_PNG)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(FAVICON_ICO), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_FAVICON_ICO)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(FORGE_LOGO_PNG), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_FORGE_LOGO_PNG)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(FORGE_STYLE_CSS), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_FORGE_STYLE_CSS)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(REMOVE_PNG), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_REMOVE_PNG)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(SEARCH_PNG), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_SEARCH_PNG)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(TRUE_PNG), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_TRUE_PNG)));
        result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(JBOSS_COMMUNITY_PNG), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_JBOSS_COMMUNITY_PNG)));
        return result;
    }

    public AccessStrategy getAccessStrategy() {
        return new FacesAccessStrategy(this.project);
    }

    public TemplateStrategy getTemplateStrategy() {
        return new FacesTemplateStrategy(this.project);
    }

    protected List<Resource<?>> generateTemplates(String targetDir) {
        ArrayList result = new ArrayList();
        try {
            WebResourcesFacet web = (WebResourcesFacet)this.project.getFacet(WebResourcesFacet.class);
            result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(PAGINATOR), (InputStream)this.getClass().getResourceAsStream(SCAFFOLD_PAGINATOR)));
            result.add(this.generateNavigation(targetDir));
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating default templates", e);
        }
        return result;
    }

    protected void loadTemplates() {
        String template;
        if (this.backingBeanTemplate == null) {
            this.backingBeanTemplate = FreemarkerTemplateProcessor.getTemplate(BACKING_BEAN_TEMPLATE);
            template = this.backingBeanTemplate.toString();
            this.backingBeanTemplateQbeMetawidgetIndent = this.parseIndent(template, "${qbeMetawidget}");
            this.backingBeanTemplateRmEntityMetawidgetIndent = this.parseIndent(template, "${rmEntityMetawidget}");
        }
        if (this.viewUtilsTemplate == null) {
            this.viewUtilsTemplate = FreemarkerTemplateProcessor.getTemplate(VIEW_UTILS_TEMPLATE);
        }
        if (this.taglibTemplate == null) {
            this.taglibTemplate = FreemarkerTemplateProcessor.getTemplate(TAGLIB_TEMPLATE);
        }
        if (this.viewTemplate == null) {
            this.viewTemplate = FreemarkerTemplateProcessor.getTemplate(VIEW_TEMPLATE);
            template = this.viewTemplate.toString();
            this.viewTemplateNamespaces = this.parseNamespaces(template);
            this.viewTemplateEntityMetawidgetIndent = this.parseIndent(template, "${metawidget}");
        }
        if (this.createTemplate == null) {
            this.createTemplate = FreemarkerTemplateProcessor.getTemplate(CREATE_TEMPLATE);
            template = this.createTemplate.toString();
            this.createTemplateNamespaces = this.parseNamespaces(template);
            this.createTemplateEntityMetawidgetIndent = this.parseIndent(template, "${metawidget}");
        }
        if (this.searchTemplate == null) {
            this.searchTemplate = FreemarkerTemplateProcessor.getTemplate(SEARCH_TEMPLATE);
            template = this.searchTemplate.toString();
            this.searchTemplateNamespaces = this.parseNamespaces(template);
            this.searchTemplateSearchMetawidgetIndent = this.parseIndent(template, "${searchMetawidget}");
            this.searchTemplateBeanMetawidgetIndent = this.parseIndent(template, "${beanMetawidget}");
        }
        if (this.navigationTemplate == null) {
            this.navigationTemplate = FreemarkerTemplateProcessor.getTemplate(NAVIGATION_TEMPLATE);
            template = this.navigationTemplate.toString();
            this.navigationTemplateIndent = this.parseIndent(template, "${navigation}");
        }
        if (this.errorTemplate == null) {
            this.errorTemplate = FreemarkerTemplateProcessor.getTemplate(ERROR_TEMPLATE);
        }
        if (this.indexTemplate == null) {
            this.indexTemplate = FreemarkerTemplateProcessor.getTemplate(INDEX_TEMPLATE);
        }
        if (this.indexWelcomeTemplate == null) {
            this.indexWelcomeTemplate = FreemarkerTemplateProcessor.getTemplate(INDEX_HTML_TEMPLATE);
        }
    }

    protected HashMap<Object, Object> getTemplateContext(String targetDir, Resource<?> template) {
        TemplateStrategy templateStrategy = this.getTemplateStrategy();
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put("template", template);
        context.put("templatePath", templateStrategy.getReferencePath(template != null ? template : templateStrategy.getDefaultTemplate()));
        context.put("templatePath", SCAFFOLD_NAVIGATION_TEMPLATE);
        context.put("templateStrategy", templateStrategy);
        context.put("targetDir", targetDir);
        return context;
    }

    protected void setupWebXML() {
        WebResourcesFacet web = (WebResourcesFacet)this.project.getFacet(WebResourcesFacet.class);
        ServletFacet servlet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppCommonDescriptor servletConfig = (WebAppCommonDescriptor)servlet.getConfig();
        Node root = ((NodeDescriptor)servletConfig).getRootNode();
        this.removeConflictingErrorPages(root);
        List webPaths = this.getAccessStrategy().getWebPaths((Resource)web.getWebResource(ERROR_XHTML));
        String errorLocation = webPaths.size() > 1 ? (String)webPaths.get(1) : "/faces/error.xhtml";
        this.createErrorPageEntry(servletConfig, errorLocation, "404");
        this.createErrorPageEntry(servletConfig, errorLocation, "500");
        boolean found = false;
        List allContextParam = servletConfig.getAllContextParam();
        for (ParamValueCommonType contextParam : allContextParam) {
            if (!contextParam.getParamName().equals("javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE")) continue;
            found = true;
        }
        if (!found) {
            servletConfig.createContextParam().paramName("javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE").paramValue("true");
        }
        servlet.saveConfig((Object)servletConfig);
    }

    private void removeConflictingErrorPages(Node root) {
        List nodeList = root.get("error-page");
        for (Node errorPage : nodeList) {
            String errorCode = errorPage.getTextValueForPatternName("error-code");
            if (!errorCode.equals("404") && !errorCode.equals("500")) continue;
            root.removeChild(errorPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource<?> generateNavigation(String targetDir) throws IOException {
        WebResourcesFacet web = (WebResourcesFacet)this.project.getFacet(WebResourcesFacet.class);
        HtmlTag unorderedList = new HtmlTag("ul");
        ResourceFilter filter = new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                FileResource file = (FileResource)resource;
                return file.isDirectory() && !file.getName().equals("resources") && !file.getName().equals("WEB-INF") && !file.getName().equals("META-INF");
            }
        };
        for (Resource resource : web.getWebResource(targetDir + "/").listResources(filter)) {
            HtmlOutcomeTargetLink outcomeTargetLink = new HtmlOutcomeTargetLink();
            String outcome = targetDir.isEmpty() || targetDir.startsWith("/") ? targetDir : "/" + targetDir;
            outcomeTargetLink.putAttribute("outcome", outcome + "/" + resource.getName() + "/search");
            outcomeTargetLink.setValue(StringUtils.uncamelCase((String)resource.getName()));
            HtmlTag listItem = new HtmlTag("li");
            listItem.getChildren().add(outcomeTargetLink);
            unorderedList.getChildren().add(listItem);
        }
        StaticUtils.IndentedWriter writer = new StaticUtils.IndentedWriter((Writer)new StringWriter(), this.navigationTemplateIndent);
        unorderedList.write((Writer)writer);
        HashMap context = CollectionUtils.newHashMap();
        context.put("appName", StringUtils.uncamelCase((String)this.project.getRoot().getName()));
        context.put("navigation", writer.toString().trim());
        context.put("targetDir", targetDir);
        if (this.navigationTemplate == null) {
            this.loadTemplates();
        }
        try {
            Resource resource = ScaffoldUtil.createOrOverwrite((FileResource)((FileResource)this.getTemplateStrategy().getDefaultTemplate()), (String)FreemarkerTemplateProcessor.processTemplate((Map<Object, Object>)context, this.navigationTemplate));
            return resource;
        }
        finally {
            writer.close();
        }
    }

    protected Map<String, String> parseNamespaces(String template) {
        HashMap namespaces = CollectionUtils.newHashMap();
        Document document = XmlUtils.documentFromString((String)template);
        Element element = document.getDocumentElement();
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int loop = 0; loop < length; ++loop) {
            org.w3c.dom.Node node = attributes.item(loop);
            String nodeName = node.getNodeName();
            int indexOf = nodeName.indexOf(XMLNS_PREFIX);
            if (indexOf == -1) continue;
            namespaces.put(nodeName.substring(indexOf + XMLNS_PREFIX.length()), node.getNodeValue());
        }
        return namespaces;
    }

    protected int parseIndent(String template, String indentOf) {
        int indent = 0;
        for (int indexOf = template.indexOf(indentOf); indexOf >= 0 && template.charAt(indexOf) != '\n'; --indexOf) {
            if (template.charAt(indexOf) != '\t') continue;
            ++indent;
        }
        return indent;
    }

    private void resetMetaWidgets() {
        ForgeConfigReader configReader = new ForgeConfigReader(this.getConfig(), this.project);
        this.entityMetawidget = new StaticHtmlMetawidget();
        this.entityMetawidget.setConfigReader((ConfigReader)configReader);
        this.entityMetawidget.setConfig(SCAFFOLD_META_WIDGET_ENTITY);
        this.searchMetawidget = new StaticHtmlMetawidget();
        this.searchMetawidget.setConfigReader((ConfigReader)configReader);
        this.searchMetawidget.setConfig(SCAFFOLD_META_WIDGET_SEARCH);
        this.beanMetawidget = new StaticHtmlMetawidget();
        this.beanMetawidget.setConfigReader((ConfigReader)configReader);
        this.beanMetawidget.setConfig(SCAFFOLD_META_WIDGET_BEAN);
        this.qbeMetawidget = new StaticJavaMetawidget();
        this.qbeMetawidget.setConfigReader((ConfigReader)configReader);
        this.qbeMetawidget.setConfig(SCAFFOLD_META_WIDGET_QBE);
        this.rmEntityMetawidget = new StaticJavaMetawidget();
        this.rmEntityMetawidget.setConfigReader((ConfigReader)configReader);
        this.rmEntityMetawidget.setConfig(SCAFFOLD_META_WIDGET_REMOVE_ENTITY);
    }

    private List<Resource<?>> generateFromEntity(String targetDir, Resource<?> template, JavaClassSource entity) {
        this.resetMetaWidgets();
        ArrayList result = new ArrayList();
        try {
            JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
            WebResourcesFacet web = (WebResourcesFacet)this.project.getFacet(WebResourcesFacet.class);
            JPAFacet jpa = (JPAFacet)this.project.getFacet(JPAFacet.class);
            this.loadTemplates();
            HashMap<Object, Object> context = CollectionUtils.newHashMap();
            context.put("entity", entity);
            String ccEntity = StringUtils.decapitalize((String)entity.getName());
            context.put("ccEntity", ccEntity);
            context.put("rmEntity", ccEntity + "ToDelete");
            this.setPrimaryKeyMetaData((Map<Object, Object>)context, entity);
            this.qbeMetawidget.setPath(entity.getQualifiedName());
            StringWriter stringWriter = new StringWriter();
            this.qbeMetawidget.write((Writer)stringWriter, this.backingBeanTemplateQbeMetawidgetIndent);
            context.put("qbeMetawidget", stringWriter.toString().trim());
            this.rmEntityMetawidget.setPath(entity.getQualifiedName());
            stringWriter = new StringWriter();
            this.rmEntityMetawidget.write((Writer)stringWriter, this.backingBeanTemplateRmEntityMetawidgetIndent);
            context.put("rmEntityMetawidget", stringWriter.toString().trim());
            Set qbeMetawidgetImports = this.qbeMetawidget.getImports();
            Set rmEntityMetawidgetImports = this.rmEntityMetawidget.getImports();
            HashSet metawidgetImports = CollectionUtils.newHashSet();
            metawidgetImports.addAll(qbeMetawidgetImports);
            metawidgetImports.addAll(rmEntityMetawidgetImports);
            metawidgetImports.remove(entity.getQualifiedName());
            context.put("metawidgetImports", CollectionUtils.toString((Collection)metawidgetImports, (String)";\r\nimport ", (boolean)true, (boolean)false));
            context.put("persistenceUnitName", ((PersistenceCommonDescriptor)jpa.getConfig()).getOrCreatePersistenceUnit().getName());
            JavaClassSource viewBean = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)FreemarkerTemplateProcessor.processTemplate((Map<Object, Object>)context, this.backingBeanTemplate));
            viewBean.setPackage(java.getBasePackage() + "." + "view");
            result.add(ScaffoldUtil.createOrOverwrite((FileResource)java.getJavaResource((JavaSource)viewBean), (String)viewBean.toString()));
            context = this.getTemplateContext(targetDir, template);
            String beanName = StringUtils.decapitalize((String)viewBean.getName());
            context.put("beanName", beanName);
            context.put("ccEntity", ccEntity);
            context.put("entityName", StringUtils.uncamelCase((String)entity.getName()));
            this.setPrimaryKeyMetaData(context, entity);
            this.entityMetawidget.setValue(StaticFacesUtils.wrapExpression((String)(beanName + "." + ccEntity)));
            this.entityMetawidget.setPath(entity.getQualifiedName());
            this.entityMetawidget.setReadOnly(false);
            this.entityMetawidget.setStyle(null);
            this.writeEntityMetawidget(context, this.createTemplateEntityMetawidgetIndent, this.createTemplateNamespaces);
            result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(targetDir + "/" + ccEntity + "/create.xhtml"), (String)FreemarkerTemplateProcessor.processTemplate(context, this.createTemplate)));
            this.entityMetawidget.setReadOnly(true);
            this.writeEntityMetawidget(context, this.viewTemplateEntityMetawidgetIndent, this.viewTemplateNamespaces);
            result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(targetDir + "/" + ccEntity + "/view.xhtml"), (String)FreemarkerTemplateProcessor.processTemplate(context, this.viewTemplate)));
            this.searchMetawidget.setValue(StaticFacesUtils.wrapExpression((String)(beanName + ".example")));
            this.searchMetawidget.setPath(entity.getQualifiedName());
            this.beanMetawidget.setValue(StaticFacesUtils.wrapExpression((String)(beanName + ".pageItems")));
            this.beanMetawidget.setPath(viewBean.getQualifiedName() + "/pageItems");
            this.writeSearchAndBeanMetawidget(context, this.searchTemplateSearchMetawidgetIndent, this.searchTemplateBeanMetawidgetIndent, this.searchTemplateNamespaces);
            result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource(targetDir + "/" + ccEntity + "/search.xhtml"), (String)FreemarkerTemplateProcessor.processTemplate(context, this.searchTemplate)));
            result.add(this.generateNavigation(targetDir));
            JavaClassSource viewUtils = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)FreemarkerTemplateProcessor.processTemplate(context, this.viewUtilsTemplate));
            viewUtils.setPackage(viewBean.getPackage());
            result.add(ScaffoldUtil.createOrOverwrite((FileResource)java.getJavaResource((JavaSource)viewUtils), (String)viewUtils.toString()));
            context.put("viewPackage", viewBean.getPackage());
            result.add(ScaffoldUtil.createOrOverwrite((FileResource)web.getWebResource("WEB-INF/classes/META-INF/forge.taglib.xml"), (String)FreemarkerTemplateProcessor.processTemplate(context, this.taglibTemplate)));
            this.createInitializers(entity);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating default scaffolding: " + e.getMessage(), e);
        }
        return result;
    }

    protected void writeEntityMetawidget(Map<Object, Object> context, int entityMetawidgetIndent, Map<String, String> existingNamespaces) {
        StringWriter stringWriter = new StringWriter();
        this.entityMetawidget.write((Writer)stringWriter, entityMetawidgetIndent);
        context.put("metawidget", stringWriter.toString().trim());
        Map namespaces = this.entityMetawidget.getNamespaces();
        namespaces.keySet().removeAll(existingNamespaces.keySet());
        context.put("metawidgetNamespaces", this.namespacesToString(namespaces));
    }

    protected void writeSearchAndBeanMetawidget(Map<Object, Object> context, int searchMetawidgetIndent, int beanMetawidgetIndent, Map<String, String> existingNamespaces) {
        StringWriter stringWriter = new StringWriter();
        this.searchMetawidget.write((Writer)stringWriter, searchMetawidgetIndent);
        context.put("searchMetawidget", stringWriter.toString().trim());
        stringWriter = new StringWriter();
        this.beanMetawidget.write((Writer)stringWriter, beanMetawidgetIndent);
        context.put("beanMetawidget", stringWriter.toString().trim());
        Map namespaces = this.searchMetawidget.getNamespaces();
        namespaces.putAll(this.beanMetawidget.getNamespaces());
        namespaces.keySet().removeAll(existingNamespaces.keySet());
        context.put("metawidgetNamespaces", this.namespacesToString(namespaces));
    }

    protected String namespacesToString(Map<String, String> namespaces) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            builder.append("\"\r\n\txmlns:");
            builder.append(entry.getKey());
            builder.append("=\"");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    protected void createInitializers(JavaClassSource entity) throws FacetNotFoundException, FileNotFoundException {
        AnnotationSource oneToOne;
        boolean dirtyBit = false;
        for (FieldSource field : entity.getFields()) {
            String methodName;
            if (!field.hasAnnotation(OneToOne.class)) continue;
            oneToOne = field.getAnnotation(OneToOne.class);
            if (oneToOne.getStringValue("mappedBy") == null && oneToOne.getStringValue("cascade") == null) {
                oneToOne.setEnumValue("cascade", (Enum)CascadeType.ALL);
                dirtyBit = true;
            }
            if (entity.hasMethodSignature(methodName = "new" + StringUtils.capitalize((String)field.getName()))) continue;
            ((MethodSource)((MethodSource)entity.addMethod().setName(methodName)).setReturnTypeVoid().setPublic()).setBody("this." + field.getName() + " = new " + field.getType().getName() + "();");
            dirtyBit = true;
        }
        for (MethodSource method : entity.getMethods()) {
            if (!method.hasAnnotation(OneToOne.class)) continue;
            oneToOne = method.getAnnotation(OneToOne.class);
            if (oneToOne.getStringValue("mappedBy") == null && oneToOne.getStringValue("cascade") == null) {
                oneToOne.setEnumValue("cascade", (Enum)CascadeType.ALL);
                dirtyBit = true;
            }
            String fieldName = StringUtils.camelCase((String)method.getName().substring(3));
            String methodName = "new" + StringUtils.capitalize((String)fieldName);
            if (entity.hasMethodSignature(methodName)) continue;
            ((MethodSource)((MethodSource)entity.addMethod().setName(methodName)).setReturnTypeVoid().setPublic()).setBody("this." + fieldName + " = new " + method.getReturnType().getName() + "();");
            dirtyBit = true;
        }
        if (dirtyBit) {
            ((JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class)).saveJavaSource((JavaSource)entity);
        }
    }

    private void setPrimaryKeyMetaData(Map<Object, Object> context, JavaClassSource entity) {
        String pkName = "id";
        String pkType = "Long";
        String nullablePkType = "Long";
        for (MemberSource m : entity.getMembers()) {
            if (!m.hasAnnotation(Id.class)) continue;
            if (m instanceof Field) {
                Field field = (Field)m;
                pkName = field.getName();
                nullablePkType = pkType = field.getType().getQualifiedName();
                break;
            }
            MethodSource method = (MethodSource)m;
            pkName = method.getName().substring(3);
            pkType = method.getName().startsWith("get") ? method.getReturnType().getQualifiedName() : ((ParameterSource)method.getParameters().get(0)).getType().getQualifiedName();
            nullablePkType = pkType;
            break;
        }
        if (Types.isJavaLang((String)pkType)) {
            nullablePkType = Types.toSimpleName((String)pkType);
        } else if ("int".equals(pkType)) {
            nullablePkType = Integer.class.getSimpleName();
        } else if ("short".equals(pkType)) {
            nullablePkType = Short.class.getSimpleName();
        } else if ("byte".equals(pkType)) {
            nullablePkType = Byte.class.getSimpleName();
        } else if ("long".equals(pkType)) {
            nullablePkType = Long.class.getSimpleName();
        }
        context.put("primaryKey", pkName);
        context.put("primaryKeyCC", StringUtils.capitalize((String)pkName));
        context.put("primaryKeyType", pkType);
        context.put("nullablePrimaryKeyType", nullablePkType);
    }

    private void createErrorPageEntry(WebAppCommonDescriptor servletConfig, String errorLocation, String errorCode) {
        List allErrorPage = servletConfig.getAllErrorPage();
        for (ErrorPageCommonType errorPageType : allErrorPage) {
            if (!errorPageType.getErrorCode().equalsIgnoreCase(errorCode)) continue;
            return;
        }
        servletConfig.createErrorPage().errorCode(errorCode).location(errorLocation);
    }

    private Configuration getConfig() {
        return (Configuration)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), Configuration.class).get();
    }
}

