/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.scaffold.faces;

import java.io.InputStream;
import java.util.Arrays;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.util.ResourceUtil;
import org.jboss.forge.addon.scaffold.faces.TemplateStrategy;
import org.jboss.forge.furnace.util.Streams;

public class FacesTemplateStrategy
implements TemplateStrategy {
    private static final String SCAFFOLD_FORGE_TEMPLATE = "/resources/scaffold/pageTemplate.xhtml";
    private final Project project;

    public FacesTemplateStrategy(Project project) {
        this.project = project;
    }

    @Override
    public boolean compatibleWith(Resource<?> template) {
        String contents = Streams.toString((InputStream)template.getResourceInputStream());
        for (String section : Arrays.asList("main")) {
            if (contents.matches(".*:\\s*insert\\s+name\\s*=\\s*\"" + section + "\".*")) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getReferencePath(Resource<?> template) {
        WebResourcesFacet web = (WebResourcesFacet)this.project.getFacet(WebResourcesFacet.class);
        for (DirectoryResource dir : web.getWebRootDirectories()) {
            if (!ResourceUtil.isChildOf((Resource)dir, template)) continue;
            String relativePath = template.getFullyQualifiedName().substring(dir.getFullyQualifiedName().length());
            return relativePath;
        }
        throw new IllegalArgumentException("Not a valid template resource for this scaffold.");
    }

    public FileResource<?> getDefaultTemplate() {
        WebResourcesFacet web = (WebResourcesFacet)this.project.getFacet(WebResourcesFacet.class);
        return web.getWebResource(SCAFFOLD_FORGE_TEMPLATE);
    }
}

