/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.scaffold.faces;

import java.util.Map;
import java.util.concurrent.Callable;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.util.ResourceUtil;
import org.jboss.forge.addon.scaffold.spi.ResourceCollection;
import org.jboss.forge.addon.scaffold.spi.ScaffoldGenerationContext;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Refactory;

public class ScaffoldableEntitySelectionWizard
extends AbstractProjectCommand
implements UIWizardStep {
    private UIInput<FileResource> pageTemplate;
    private UISelectMany<JavaClassSource> targets;
    private UIInput<Boolean> useCustomTemplate;
    private UIInput<Boolean> generateEqualsAndHashCode;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.pageTemplate = (UIInput)((UIInput)factory.createInput("pageTemplate", FileResource.class).setLabel("Facelet Template")).setDescription("The Facelets template file to be used in the generated facelets.");
        this.targets = (UISelectMany)((UISelectMany)((UISelectMany)factory.createSelectMany("targets", JavaClassSource.class).setLabel("Targets")).setRequired(true)).setDescription("The JPA entities to use as the basis for generating the scaffold.");
        this.useCustomTemplate = (UIInput)((UIInput)factory.createInput("useCustomTemplate", Boolean.class).setLabel("Use custom template when generating pages")).setDescription("Enabling this will allow the generated scaffold to use the specified Facelet template.");
        this.generateEqualsAndHashCode = (UIInput)((UIInput)factory.createInput("generateEqualsAndHashCode", Boolean.class).setLabel("Generate missing .equals() and .hashCode() methods")).setDescription("If enabled, entities missing an .equals() or .hashCode() method will be updated to provide them");
        UIContext uiContext = builder.getUIContext();
        Project project = this.getSelectedProject((UIContextProvider)builder);
        JPAFacet persistenceFacet = (JPAFacet)project.getFacet(JPAFacet.class);
        this.targets.setValueChoices((Iterable)persistenceFacet.getAllEntities());
        this.targets.setItemLabelConverter(source -> source.getQualifiedName());
        builder.add(this.targets);
        if (uiContext.getProvider().isGUI()) {
            this.useCustomTemplate.setDefaultValue((Object)false);
            this.pageTemplate.setEnabled(() -> (Boolean)this.useCustomTemplate.getValue());
            builder.add(this.useCustomTemplate).add(this.pageTemplate);
        } else {
            builder.add(this.pageTemplate);
        }
        this.generateEqualsAndHashCode.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (JavaClassSource javaSource : ScaffoldableEntitySelectionWizard.this.targets.getValue()) {
                    if (javaSource.hasMethodSignature("hashCode") && javaSource.hasMethodSignature("equals", new Class[]{Object.class})) continue;
                    return true;
                }
                return false;
            }
        });
        builder.add(this.generateEqualsAndHashCode);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Map attributeMap = uiContext.getAttributeMap();
        ResourceCollection resourceCollection = new ResourceCollection();
        if (this.targets.getValue() != null) {
            for (JavaClassSource klass : this.targets.getValue()) {
                Project project = this.getSelectedProject(uiContext);
                JavaSourceFacet javaSource = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
                JavaResource resource = javaSource.getJavaResource((JavaSource)klass);
                if (resource == null) continue;
                resourceCollection.addToCollection((Resource)resource);
            }
        }
        attributeMap.put(ResourceCollection.class, resourceCollection);
        ScaffoldGenerationContext genCtx = (ScaffoldGenerationContext)attributeMap.get(ScaffoldGenerationContext.class);
        if (uiContext.getProvider().isGUI()) {
            if (((Boolean)this.useCustomTemplate.getValue()).booleanValue()) {
                genCtx.addAttribute("pageTemplate", this.pageTemplate.getValue());
            }
        } else {
            genCtx.addAttribute("pageTemplate", this.pageTemplate.getValue());
        }
        return null;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Select JPA entities").description("Select the JPA entities to be used for scaffolding.");
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        for (JavaClassSource javaSource : this.targets.getValue()) {
            UIContext uiContext = context.getUIContext();
            Project project = this.getSelectedProject(uiContext);
            JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            if (!javaSource.hasMethodSignature("hashCode") && ((Boolean)this.generateEqualsAndHashCode.getValue()).booleanValue()) {
                if (javaSource.getField("id") != null) {
                    Refactory.createHashCode((JavaClassSource)javaSource, (FieldSource[])new FieldSource[]{javaSource.getField("id")});
                } else {
                    Refactory.createHashCode((JavaClassSource)javaSource, (FieldSource[])javaSource.getFields().toArray(new FieldSource[javaSource.getFields().size()]));
                }
            }
            if (!javaSource.hasMethodSignature("equals", new Class[]{Object.class}) && ((Boolean)this.generateEqualsAndHashCode.getValue()).booleanValue()) {
                if (javaSource.getField("id") != null) {
                    Refactory.createEquals((JavaClassSource)javaSource, (FieldSource[])new FieldSource[]{javaSource.getField("id")});
                } else {
                    Refactory.createEquals((JavaClassSource)javaSource, (FieldSource[])javaSource.getFields().toArray(new FieldSource[javaSource.getFields().size()]));
                }
            }
            javaSourceFacet.saveJavaSource((JavaSource)javaSource);
        }
        return null;
    }

    public void validate(UIValidationContext context) {
        UIContext uiContext = context.getUIContext();
        if (uiContext.getProvider().isGUI()) {
            boolean useTemplate = (Boolean)this.useCustomTemplate.getValue();
            if (useTemplate) {
                this.validateTemplate(context);
            }
        } else {
            this.validateTemplate(context);
        }
    }

    private void validateTemplate(UIValidationContext context) {
        Resource template = (Resource)this.pageTemplate.getValue();
        if (template != null) {
            if (template.exists()) {
                Map attributeMap = context.getUIContext().getAttributeMap();
                Project project = (Project)attributeMap.get(Project.class);
                WebResourcesFacet web = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
                boolean isValidTemplate = false;
                for (DirectoryResource dir : web.getWebRootDirectories()) {
                    if (!ResourceUtil.isChildOf((Resource)dir, (Resource)template)) continue;
                    isValidTemplate = true;
                }
                if (!isValidTemplate) {
                    context.addValidationError(this.pageTemplate, "Not a valid template resource. The template should be located under a web root directory for the project.");
                }
            } else {
                context.addValidationError(this.pageTemplate, "The template [" + template.getName() + "] does not exist. You must select a template that exists.");
            }
        }
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

