/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.scaffold.metawidget.inspector;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.scaffold.metawidget.inspector.ForgeInspectorConfig;
import org.jboss.forge.addon.scaffold.metawidget.inspector.propertystyle.ForgePropertyStyle;
import org.jboss.forge.roaster.model.EnumConstant;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.w3c.dom.Element;

public class ForgeInspector
extends BaseObjectInspector {
    public static final int TEXT_AREA_GENERATION_LENGTH = 800;
    private Project project;
    private JavaSourceFacet java;
    private String typeUnderInspection;

    public ForgeInspector() {
        super((BaseObjectInspectorConfig)new ForgeInspectorConfig());
    }

    public ForgeInspector(ForgeInspectorConfig config) {
        super((BaseObjectInspectorConfig)config);
        this.project = config.getProject();
        if (this.project != null) {
            this.java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        }
    }

    public Element inspectAsDom(Object toInspect, String type, String ... names) {
        this.setTypeUnderInspection(type);
        return super.inspectAsDom(toInspect, type, names);
    }

    public String getTypeUnderInspection() {
        return this.typeUnderInspection;
    }

    public void setTypeUnderInspection(String typeUnderInspection) {
        this.typeUnderInspection = typeUnderInspection;
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        Column annotation;
        List<EnumConstant<?>> enumConstants;
        HashMap attributes = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(OneToOne.class)) {
            attributes.put("one-to-one", "true");
            attributes.put("jpa-relation-type", "one-to-one");
            this.getReversePrimaryKey(property, attributes);
            if (property.isAnnotationPresent(OneToOne.class)) {
                this.getOneToOneBidirectionalProperties(property, attributes);
            }
        }
        if (property.isAnnotationPresent(Embedded.class) || this.isPropertyTypeEmbeddedable(property.getType())) {
            attributes.put("embeddable", "true");
        }
        if (property.isAnnotationPresent(ManyToOne.class)) {
            attributes.put("jpa-relation-type", "many-to-one");
            attributes.put("many-to-one", "true");
            this.getReversePrimaryKey(property, attributes);
            this.getManyToOneBidirectionalProperties(property, attributes);
        }
        if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class)) {
            attributes.put("n-to-many", "true");
            this.getCollectionReversePrimaryKey(property, attributes);
            if (property.isAnnotationPresent(OneToMany.class)) {
                attributes.put("jpa-relation-type", "one-to-many");
                this.getOneToManyBidirectionalProperties(property, attributes);
            } else {
                attributes.put("jpa-relation-type", "many-to-many");
                this.getManyToManyBidirectionalProperties(property, attributes);
            }
        }
        if (property instanceof ForgePropertyStyle.ForgeProperty && (enumConstants = ((ForgePropertyStyle.ForgeProperty)property).getEnumConstants()) != null) {
            ArrayList lookup = CollectionUtils.newArrayList();
            for (EnumConstant<?> anEnum : enumConstants) {
                lookup.add(anEnum.getName());
            }
            attributes.put("lookup", CollectionUtils.toString((Collection)lookup));
        }
        if (property.isAnnotationPresent(Id.class)) {
            attributes.put("primary-key", "true");
        }
        if (property.isAnnotationPresent(GeneratedValue.class)) {
            attributes.put("generated-value", "true");
        }
        if (property.isAnnotationPresent(Column.class) && (annotation = (Column)property.getAnnotation(Column.class)).length() >= 800) {
            attributes.put("large", "true");
        }
        return attributes;
    }

    private boolean isPropertyTypeEmbeddedable(String type) {
        boolean isEmbeddable = false;
        try {
            JavaClass klass;
            JavaResource javaResource;
            JavaSource javaSource;
            if (this.java != null && (javaSource = (JavaSource)(javaResource = this.java.getJavaResource(type)).getJavaType()) instanceof JavaClass && (klass = (JavaClass)javaSource).hasAnnotation(Embeddable.class)) {
                isEmbeddable = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        return isEmbeddable;
    }

    private void getReversePrimaryKey(Property property, Map<String, String> attributes) {
        for (Property reverseProperty : this.getProperties(property.getType()).values()) {
            if (!reverseProperty.isAnnotationPresent(Id.class)) continue;
            attributes.put("reverse-primary-key", reverseProperty.getName());
            break;
        }
    }

    private void getCollectionReversePrimaryKey(Property property, Map<String, String> attributes) {
        for (Property reverseProperty : this.getProperties(property.getGenericType()).values()) {
            if (!reverseProperty.isAnnotationPresent(Id.class)) continue;
            attributes.put("reverse-primary-key", reverseProperty.getName());
            break;
        }
    }

    private void getOneToOneBidirectionalProperties(Property property, Map<String, String> attributes) {
        String owningProperty = ((OneToOne)property.getAnnotation(OneToOne.class)).mappedBy();
        String propertyName = property.getName();
        if (!owningProperty.isEmpty()) {
            attributes.put("inverse-field", propertyName);
            for (Property reverseProperty : this.getProperties(property.getType()).values()) {
                String reversePropertyName = reverseProperty.getName();
                String reversePropertyType = reverseProperty.getType();
                if (!reverseProperty.isAnnotationPresent(OneToOne.class) || !reversePropertyName.equals(owningProperty) || !reversePropertyType.equals(this.getTypeUnderInspection())) continue;
                attributes.put("owning-field", reversePropertyName);
                break;
            }
        } else {
            for (Property reverseProperty : this.getProperties(property.getType()).values()) {
                String reversePropertyName = reverseProperty.getName();
                String reversePropertyType = reverseProperty.getType();
                if (!reverseProperty.isAnnotationPresent(OneToOne.class) || ((OneToOne)reverseProperty.getAnnotation(OneToOne.class)).mappedBy().isEmpty() || !propertyName.equals(owningProperty = ((OneToOne)reverseProperty.getAnnotation(OneToOne.class)).mappedBy()) || !reversePropertyType.equals(this.getTypeUnderInspection())) continue;
                attributes.put("owning-field", propertyName);
                attributes.put("inverse-field", reversePropertyName);
                break;
            }
        }
    }

    private void getManyToOneBidirectionalProperties(Property property, Map<String, String> attributes) {
        String propertyName = property.getName();
        attributes.put("owning-field", propertyName);
        for (Property reverseProperty : this.getProperties(property.getType()).values()) {
            if (!reverseProperty.isAnnotationPresent(OneToMany.class)) continue;
            String mappedPropertyName = ((OneToMany)reverseProperty.getAnnotation(OneToMany.class)).mappedBy();
            String reversePropertyType = reverseProperty.getGenericType();
            if (!reversePropertyType.equals(this.getTypeUnderInspection()) || !mappedPropertyName.equals(propertyName)) continue;
            attributes.put("inverse-field", reverseProperty.getName());
            break;
        }
    }

    private void getOneToManyBidirectionalProperties(Property property, Map<String, String> attributes) {
        String owningProperty = ((OneToMany)property.getAnnotation(OneToMany.class)).mappedBy();
        if (!owningProperty.isEmpty()) {
            attributes.put("inverse-field", property.getName());
            for (Property reverseProperty : this.getProperties(property.getGenericType()).values()) {
                String reversePropertyName = reverseProperty.getName();
                String reversePropertyType = reverseProperty.getType();
                if (!reverseProperty.isAnnotationPresent(ManyToOne.class) || !reversePropertyName.equals(owningProperty) || !reversePropertyType.equals(this.getTypeUnderInspection())) continue;
                attributes.put("owning-field", reversePropertyName);
                break;
            }
        }
    }

    private void getManyToManyBidirectionalProperties(Property property, Map<String, String> attributes) {
        String owningProperty = ((ManyToMany)property.getAnnotation(ManyToMany.class)).mappedBy();
        String propertyName = property.getName();
        if (!owningProperty.isEmpty()) {
            attributes.put("inverse-field", propertyName);
            for (Property reverseProperty : this.getProperties(property.getGenericType()).values()) {
                String reversePropertyName = reverseProperty.getName();
                String reversePropertyGenericType = reverseProperty.getGenericType();
                if (!reverseProperty.isAnnotationPresent(ManyToMany.class) || !reversePropertyName.equals(owningProperty) || !reversePropertyGenericType.equals(this.getTypeUnderInspection())) continue;
                attributes.put("owning-field", reversePropertyName);
                break;
            }
        } else {
            for (Property reverseProperty : this.getProperties(property.getGenericType()).values()) {
                String reversePropertyName = reverseProperty.getName();
                String reversePropertyGenericType = reverseProperty.getGenericType();
                if (!reverseProperty.isAnnotationPresent(ManyToMany.class) || ((ManyToMany)reverseProperty.getAnnotation(ManyToMany.class)).mappedBy().isEmpty() || !propertyName.equals(owningProperty = ((ManyToMany)reverseProperty.getAnnotation(ManyToMany.class)).mappedBy()) || !reversePropertyGenericType.equals(this.getTypeUnderInspection())) continue;
                attributes.put("owning-field", propertyName);
                attributes.put("inverse-field", reversePropertyName);
                break;
            }
        }
    }
}

