/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.util;

import java.net.URL;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.furnace.util.Assert;

public class Metadata
implements UICommandMetadata {
    private static String[] VALID_DOC_EXTENSIONS = new String[]{".txt.gzip", ".txt.gz", ".txt", ".asciidoc.gzip", ".asciidoc.gz", ".asciidoc", ".ad"};
    private String name;
    private String description;
    private String longDescription;
    private UICategory category;
    private URL docLocation;
    private boolean deprecated;
    private String deprecatedMessage;
    private final Class<?> type;

    public static Metadata from(UICommandMetadata origin, Class<? extends UICommand> type) {
        Assert.notNull((Object)origin, (String)"Parent UICommand must not be null.");
        Assert.notNull(type, (String)"UICommand type must not be null.");
        Metadata metadata = new Metadata(type);
        metadata.docLocation(origin.getDocLocation()).name(origin.getName()).description(origin.getDescription()).category(origin.getCategory());
        return metadata;
    }

    public static Metadata forCommand(Class<?> type) {
        Assert.notNull(type, (String)"UICommand type must not be null.");
        return new Metadata(type);
    }

    private Metadata(Class<?> type2) {
        this.type = type2;
        this.docLocation(this.getDocLocationFor(type2)).name(type2.getName()).category(Categories.createDefault()).description("No Description").deprecated(this.type.getAnnotation(Deprecated.class) != null);
    }

    public Metadata name(String name) {
        this.name = name;
        return this;
    }

    public Metadata description(String description) {
        this.description = description;
        return this;
    }

    public Metadata longDescription(String description) {
        this.longDescription = description;
        return this;
    }

    public Metadata category(UICategory category) {
        this.category = category;
        return this;
    }

    public Metadata docLocation(URL docLocation) {
        this.docLocation = docLocation;
        return this;
    }

    public Metadata deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Metadata deprecatedMessage(String deprecatedMessage) {
        this.deprecatedMessage = deprecatedMessage;
        return this;
    }

    private URL getDocLocationFor(Class<?> type) {
        URL url = null;
        for (String extension : VALID_DOC_EXTENSIONS) {
            String docFileName = type.getSimpleName() + extension;
            url = type.getResource(docFileName);
            if (url != null) break;
        }
        return url;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public UICategory getCategory() {
        return this.category;
    }

    @Override
    public URL getDocLocation() {
        return this.docLocation;
    }

    public String toString() {
        return "Metadata [name=" + this.name + ", description=" + this.description + ", category=" + this.category + ", docLocation=" + this.docLocation + ", deprecated=" + this.deprecated + ", deprecatedMessage=" + this.deprecatedMessage + "]";
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public String getDeprecatedMessage() {
        return this.deprecatedMessage;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

