/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev;

import java.io.FileNotFoundException;
import java.util.HashMap;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.dev.ForgeAPIFacet;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.events.PickupResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.seam.render.TemplateCompiler;
import org.jboss.seam.render.template.CompiledTemplateResource;

@Alias(value="plugins")
@Help(value="Set up necessary features for Forge plugin development")
@RequiresProject
@RequiresFacet(value={ForgeAPIFacet.class})
public class PluginsPlugin
implements Plugin {
    @Inject
    private Event<InstallFacets> event;
    @Inject
    private Event<PickupResource> pickup;
    @Inject
    private Project project;
    @Inject
    private ShellPrompt prompt;
    @Inject
    private TemplateCompiler compiler;

    @SetupCommand
    public void setup(PipeOut out) {
        if (!this.project.hasFacet(ForgeAPIFacet.class)) {
            this.event.fire((Object)new InstallFacets(ForgeAPIFacet.class));
            if (!this.project.hasFacet(ForgeAPIFacet.class)) {
                throw new RuntimeException("Could not install Forge API");
            }
        } else {
            ShellMessages.success((ShellPrintWriter)out, (String)"Forge API is installed.");
        }
    }

    @Command(value="new-plugin")
    public void newPlugin(PipeOut out, @Option(required=true, name="named", description="The plugin name") String pluginName, @Option(name="alias", description="The plugin alias") String alias) throws FileNotFoundException {
        String pluginAlias;
        String string = pluginAlias = Strings.isNullOrEmpty((String)alias) ? pluginName.replaceAll("([^A-Za-z0-9-])|[Plugin]", "").toLowerCase() : alias;
        if (Strings.isNullOrEmpty((String)pluginAlias)) {
            throw new RuntimeException("You should specify a valid alias for this plugin");
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        String className = this.canonicalize(pluginName);
        String packg = this.prompt.promptCommon("In which package you'd like to create [" + className + "], or enter for default", PromptType.JAVA_PACKAGE, java.getBasePackage());
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("name", className);
        context.put("alias", pluginAlias);
        CompiledTemplateResource pluginSource = this.compiler.compileResource(this.getClass().getResourceAsStream("/org/jboss/forge/dev/PluginTemplate.jv"));
        CompiledTemplateResource testSource = this.compiler.compileResource(this.getClass().getResourceAsStream("/org/jboss/forge/dev/PluginTemplateTest.jv"));
        JavaResource pluginResource = java.saveJavaSource((JavaSource)((JavaClass)JavaParser.parse(JavaClass.class, (String)pluginSource.render(context))).setPackage(packg));
        java.saveTestJavaSource((JavaSource)((JavaClass)JavaParser.parse(JavaClass.class, (String)testSource.render(context))).setPackage(packg));
        this.pickup.fire((Object)new PickupResource((Resource)pluginResource));
    }

    public String canonicalize(String name) {
        String[] split;
        StringBuilder result = new StringBuilder();
        for (String string : split = name.split("[^A-Za-z0-9]")) {
            result.append(Strings.capitalize((String)string));
        }
        return result.toString();
    }
}

