/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev.mvn;

import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.jboss.forge.dev.mvn.VersionUpdater;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.maven.plugins.MavenPluginInstaller;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.PathspecParser;

@Alias(value="maven")
@Topic(value="Project")
@RequiresProject
@RequiresFacet(value={MavenCoreFacet.class})
@RequiresResource(value={DirectoryResource.class})
public class MavenPlugin
implements Plugin {
    private final Shell shell;
    private final Project project;
    private final ProjectFactory factory;
    private final ResourceFactory resources;
    private final BeanManager manager;
    private final MavenPluginInstaller mavenPluginInstaller;

    @Inject
    public MavenPlugin(Shell shell, Project project, ProjectFactory factory, ResourceFactory resources, MavenPluginInstaller mavenPluginInstaller, BeanManager manager) {
        this.shell = shell;
        this.project = project;
        this.factory = factory;
        this.resources = resources;
        this.manager = manager;
        this.mavenPluginInstaller = mavenPluginInstaller;
    }

    @Command(value="set-groupid")
    public void setGroupId(PipeOut out, @Option(description="the new groupId; for example: \"org.jboss.forge\"") String groupId) {
        Assert.notNull((Object)groupId, (String)"GroupId must not be empty");
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        pom.setGroupId(groupId);
        mvn.setPOM(pom);
        out.println("Set groupId [ " + groupId + " ]");
    }

    @Command(value="set-artifactid")
    public void setArtifactId(PipeOut out, @Option(description="the new artifactId; for example: \"forge-shell\"") String artifactId) {
        Assert.notNull((Object)artifactId, (String)"GroupId must not be empty");
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        pom.setArtifactId(artifactId);
        mvn.setPOM(pom);
        out.println("Set artifactId [ " + artifactId + " ]");
    }

    @Command(value="set-version")
    public void setVersion(PipeOut out, @Option(description="the new version; for example: \"1.0.0.Final\"") String version) {
        Assert.notNull((Object)version, (String)"GroupId must not be empty");
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        pom.setVersion(version);
        mvn.setPOM(pom);
        out.println("Set version [ " + version + " ]");
    }

    @Command(value="set-name")
    public void setName(PipeOut out, @Option(description="the new name; for example: \"UI-Layer\"") String name) {
        Assert.notNull((Object)name, (String)"Name must not be empty");
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        pom.setName(name);
        mvn.setPOM(pom);
        out.println("Set name [ " + name + " ]");
    }

    @Command(value="set-parent")
    public void setParent(@Option(name="parentId", description="dependency identifier of parent, ex: \"org.jboss.forge:forge-parent:1.0.0\"", required=false) Dependency gav, @Option(name="parentRelativePath", description="relative location from the current project to the parent project root folder", type=PromptType.FILE_PATH, required=false) String relativePath, @Option(name="parentProjectRoot", description="absolute location of a project to use as this project's direct parent", required=false) Resource<?> path, PipeOut out) {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Parent parent = null;
        if (gav != null) {
            Assert.notNull((Object)gav.getArtifactId(), (String)("ArtifactId must not be null [" + gav.toCoordinates() + "]"));
            Assert.notNull((Object)gav.getGroupId(), (String)("GroupId must not be null [" + gav.toCoordinates() + "]"));
            Assert.notNull((Object)gav.getVersion(), (String)("Version must not be null [" + gav.toCoordinates() + "]"));
            parent = new Parent();
            parent.setArtifactId(gav.getArtifactId());
            parent.setGroupId(gav.getGroupId());
            parent.setVersion(gav.getVersion());
            if (relativePath != null) {
                parent.setRelativePath(relativePath);
            }
            Model pom = mvn.getPOM();
            pom.setParent(parent);
            mvn.setPOM(pom);
        } else if (path != null && this.factory.containsProject((DirectoryResource)path.reify(DirectoryResource.class))) {
            Project parentProject = this.factory.findProject((DirectoryResource)path.reify(DirectoryResource.class));
            MavenCoreFacet parentCore = (MavenCoreFacet)parentProject.getFacet(MavenCoreFacet.class);
            parent = new Parent();
            parent.setArtifactId(parentCore.getMavenProject().getArtifactId());
            parent.setGroupId(parentCore.getMavenProject().getGroupId());
            parent.setVersion(parentCore.getMavenProject().getVersion());
            if (relativePath != null) {
                parent.setRelativePath(relativePath);
            }
            Model pom = mvn.getPOM();
            pom.setParent(parent);
            mvn.setPOM(pom);
        } else if (relativePath != null) {
            PathspecParser parser = new PathspecParser(this.resources, (Resource)this.shell.getCurrentProject().getProjectRoot(), relativePath);
            List resolvedResources = parser.resolve();
            if (!resolvedResources.isEmpty() && this.factory.containsProject((DirectoryResource)((Resource)resolvedResources.get(0)).reify(DirectoryResource.class))) {
                Project parentProject = this.factory.findProject((DirectoryResource)((Resource)resolvedResources.get(0)).reify(DirectoryResource.class));
                MavenCoreFacet parentCore = (MavenCoreFacet)parentProject.getFacet(MavenCoreFacet.class);
                parent = new Parent();
                parent.setArtifactId(parentCore.getMavenProject().getArtifactId());
                parent.setGroupId(parentCore.getMavenProject().getGroupId());
                parent.setVersion(parentCore.getMavenProject().getVersion());
                parent.setRelativePath(relativePath);
                Model pom = mvn.getPOM();
                pom.setParent(parent);
                mvn.setPOM(pom);
            } else {
                out.print(ShellColor.RED, "***ERROR***");
                out.println(" relative path did not resolve to a Project [" + relativePath + "]");
            }
        } else {
            out.print(ShellColor.RED, "***ERROR***");
            out.println(" you must specify a path to or dependency id of the parent project.");
        }
        if (parent != null) {
            String parentId = parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion() + " (" + (parent.getRelativePath() == null ? " " : parent.getRelativePath() + ")");
            out.println("Set parent [ " + parentId + " ]");
        }
    }

    @Command(value="remove-parent")
    public void removeParent(PipeOut out) {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        Parent parent = pom.getParent();
        if (parent != null) {
            String parentId = parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion() + " (" + (parent.getRelativePath() == null ? " " : parent.getRelativePath() + ")");
            if (this.shell.promptBoolean("Are you sure you want to remove all parent information from this project? [ " + parentId + "]", false)) {
                out.println("Removed parent [ " + parentId + " ]");
                pom.setParent(null);
                mvn.setPOM(pom);
            } else {
                out.println("Aborted...");
            }
        } else {
            out.println("Nothing to remove...");
        }
    }

    @Command(value="update")
    public void updateDependencies() {
        if (!new VersionUpdater(this.project, this.shell, this.factory, this.manager).update()) {
            this.shell.println("No nothing to update");
        }
    }

    @Command(value="add-plugin")
    public void addPlugin(@Option(description="dependency identifier of plugin, ex: \"org.jboss.forge:forge-maven-plugin:1.0.0.Final\"", required=true) Dependency gav, PipeOut out) {
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setDependency(gav);
        if (!this.mavenPluginInstaller.isInstalled(this.project, (org.jboss.forge.maven.plugins.MavenPlugin)plugin)) {
            this.mavenPluginInstaller.install(this.project, (org.jboss.forge.maven.plugins.MavenPlugin)plugin);
        }
    }

    @Command(value="add-managed-plugin")
    public void addManagedPlugin(@Option(description="dependency identifier of plugin, ex: \"org.jboss.forge:forge-maven-plugin:1.0.0.Final\"", required=true) Dependency gav, PipeOut out) {
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setDependency(gav);
        if (!this.mavenPluginInstaller.isInstalled(this.project, (org.jboss.forge.maven.plugins.MavenPlugin)plugin)) {
            this.mavenPluginInstaller.installManaged(this.project, (org.jboss.forge.maven.plugins.MavenPlugin)plugin);
        }
    }
}

