/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev.mvn;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.dependencies.MavenDependencyAdapter;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.events.UpdatedDependency;
import org.jboss.forge.project.dependencies.events.UpdatingDependency;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;

public class VersionUpdater {
    private Project project;
    private Shell shell;
    private ProjectFactory projectFactory;
    private BeanManager manager;

    public VersionUpdater(Project project, Shell shell, ProjectFactory projectFactory, BeanManager manager) {
        this.project = project;
        this.shell = shell;
        this.projectFactory = projectFactory;
        this.manager = manager;
    }

    public boolean update() {
        return this.update(this.project, new Properties[0]);
    }

    private Properties[] append(Properties[] parent, Properties ... children) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        if (children != null) {
            result.addAll(Arrays.asList(children));
        }
        if (parent != null) {
            result.addAll(Arrays.asList(parent));
        }
        return result.toArray(new Properties[0]);
    }

    public boolean update(Project currentProject, Properties ... parentProperties) {
        boolean updated = false;
        MavenCoreFacet mavenFacet = (MavenCoreFacet)currentProject.getFacet(MavenCoreFacet.class);
        DependencyFacet depFacet = (DependencyFacet)currentProject.getFacet(DependencyFacet.class);
        Model pom = mavenFacet.getPOM();
        for (org.apache.maven.model.Dependency dependency : pom.getDependencies()) {
            if (!this.updateDependency(depFacet, dependency, this.append(parentProperties, pom.getProperties()))) continue;
            mavenFacet.setPOM(pom);
            updated = true;
        }
        if (pom.getDependencyManagement() != null) {
            for (org.apache.maven.model.Dependency dependency : pom.getDependencyManagement().getDependencies()) {
                if (!this.updateDependency(depFacet, dependency, this.append(parentProperties, pom.getProperties()))) continue;
                mavenFacet.setPOM(pom);
                updated = true;
            }
        }
        for (Profile profile : pom.getProfiles()) {
            for (org.apache.maven.model.Dependency dependency : profile.getDependencies()) {
                if (!this.updateDependency(depFacet, dependency, this.append(parentProperties, profile.getProperties(), pom.getProperties()))) continue;
                mavenFacet.setPOM(pom);
                updated = true;
            }
            if (profile.getDependencyManagement() == null) continue;
            for (org.apache.maven.model.Dependency dependency : profile.getDependencyManagement().getDependencies()) {
                if (!this.updateDependency(depFacet, dependency, this.append(parentProperties, profile.getProperties(), pom.getProperties()))) continue;
                mavenFacet.setPOM(pom);
                updated = true;
            }
        }
        for (String module : pom.getModules()) {
            Project subProject = this.projectFactory.findProject(currentProject.getProjectRoot().getChildDirectory(module));
            if (!this.update(subProject, this.append(parentProperties, pom.getProperties()))) continue;
            mavenFacet.setPOM(pom);
            updated = true;
        }
        return updated;
    }

    private boolean updateDependency(DependencyFacet depFacet, org.apache.maven.model.Dependency dependency, Properties ... propertySets) {
        String version;
        if (dependency.getVersion() == null) {
            return false;
        }
        String propertyName = this.getExpressionName(dependency.getVersion());
        if (this.isExpression(dependency.getVersion())) {
            boolean propertyFound = false;
            for (Properties properties : propertySets) {
                if (!properties.containsKey(propertyName)) continue;
                propertyFound = true;
            }
            if (!propertyFound) {
                this.shell.println("Can not update dependency with expression located in different pom: " + propertyName);
                this.shell.println("\t" + dependency);
                return false;
            }
        }
        if ((version = this.findNewerVersions(depFacet, dependency)) != null) {
            Dependency from = depFacet.resolveProperties((Dependency)new MavenDependencyAdapter(dependency));
            DependencyBuilder to = DependencyBuilder.create((Dependency)depFacet.resolveProperties((Dependency)new MavenDependencyAdapter(dependency))).setVersion(version);
            UpdatingDependency preEvent = new UpdatingDependency(this.project, from, (Dependency)to);
            this.manager.fireEvent((Object)preEvent, new Annotation[0]);
            if (!preEvent.isVetoed()) {
                if (this.isExpression(dependency.getVersion())) {
                    for (Properties properties : propertySets) {
                        if (!properties.containsKey(propertyName)) continue;
                        properties.put(propertyName, version);
                    }
                } else {
                    dependency.setVersion(version);
                }
                UpdatedDependency event = new UpdatedDependency(this.project, from, (Dependency)to);
                this.manager.fireEvent((Object)event, new Annotation[0]);
                return true;
            }
            this.shell.println("Update attempt vetoed by other Plugin");
            for (String message : preEvent.getMessages()) {
                this.shell.println("\t" + message);
            }
            return false;
        }
        return false;
    }

    private String findNewerVersions(DependencyFacet facet, org.apache.maven.model.Dependency dependency) {
        String currentVersion = dependency.getVersion();
        if (currentVersion == null || currentVersion.equals("")) {
            return null;
        }
        Dependency resolved = facet.resolveProperties((Dependency)new MavenDependencyAdapter(dependency));
        DependencyBuilder query = DependencyBuilder.create((Dependency)resolved).setVersion("(" + resolved.getVersion() + ",)");
        List foundVersions = facet.resolveAvailableVersions((Dependency)query);
        if (foundVersions == null || foundVersions.size() == 0) {
            return null;
        }
        String gav = dependency.getGroupId() + ":" + dependency.getArtifactId();
        Dependency latest = (Dependency)foundVersions.get(foundVersions.size() - 1);
        if (resolved.getVersion().equals(latest.getVersion())) {
            return null;
        }
        List<Option> options = Arrays.asList(new Option(Option.OptionType.YES, "Yes"), new Option(Option.OptionType.NO, "No"), new Option(Option.OptionType.OTHER, MessageFormat.format("Show {0} other versions", this.shell.renderColor(ShellColor.BOLD, String.valueOf(foundVersions.size())))));
        Option option = (Option)this.shell.promptChoiceTyped(MessageFormat.format("Update {0} from {1} to {2}?", gav, resolved.getVersion(), latest.getVersion()), options, (Object)options.get(0));
        switch (option.getType()) {
            case YES: {
                return latest.getVersion();
            }
            case OTHER: {
                Dependency choice = (Dependency)this.shell.promptChoiceTyped("Which version would you like to update to?", foundVersions, (Object)latest);
                return choice.getVersion();
            }
        }
        this.shell.println("Skipping " + gav);
        return null;
    }

    private boolean isExpression(String value) {
        return value != null && value.startsWith("${");
    }

    private String getExpressionName(String value) {
        return value.replaceAll("\\$\\{(.*)\\}", "$1");
    }

    private static class Option {
        private String display;
        private OptionType type;

        public Option(OptionType type, String display) {
            this.type = type;
            this.display = display;
        }

        public OptionType getType() {
            return this.type;
        }

        public String toString() {
            return this.display;
        }

        public static enum OptionType {
            YES,
            NO,
            OTHER;

        }
    }
}

