/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git.gitignore;

import javax.inject.Inject;
import org.jboss.forge.git.gitignore.GitIgnorePatternCompleter;
import org.jboss.forge.git.gitignore.GitIgnoreResource;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.RequiresResource;

@Alias(value="gitignore-edit")
@Help(value="Manage the contents of .gitignore files")
@RequiresProject
@RequiresResource(value={GitIgnoreResource.class})
public class GitIgnoreContent
implements Plugin {
    @Inject
    @Current
    private GitIgnoreResource gitIgnore;
    @Inject
    private Project project;
    @Inject
    private Shell shell;

    @Command(help="List the ignore patterns")
    public void list(PipeOut out) {
        for (String pattern : this.gitIgnore.getPatterns()) {
            out.println(pattern);
        }
    }

    @Command(help="Add ignore pattern")
    public void add(@Option(description="pattern", required=true) String pattern, PipeOut out) {
        this.gitIgnore.addPattern(pattern);
        out.println("Pattern added to the .gitignore in the current directory");
    }

    @Command(help="Remove ignore pattern")
    public void remove(@Option(description="pattern", required=true, completer=GitIgnorePatternCompleter.class) String pattern, PipeOut out) {
        this.gitIgnore.removePattern(pattern);
        out.println("Pattern removed from the .gitignore in the current directory");
    }
}

