/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git.gitignore;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.inject.Inject;
import org.jboss.forge.git.gitignore.GitIgnoreFacet;
import org.jboss.forge.git.gitignore.GitIgnoreTemplateGroup;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.CommandCompleterState;

public class GitIgnoreTemplateCompleter
implements CommandCompleter {
    @Inject
    private Project project;
    @Inject
    private Shell shell;

    public void complete(CommandCompleterState state) {
        Queue tokens = state.getTokens();
        String peek = (String)tokens.peek();
        List<String> candidates = this.candidates(peek);
        if (!candidates.isEmpty()) {
            if (!Strings.isNullOrEmpty((String)peek)) {
                state.setIndex(state.getBuffer().lastIndexOf(peek));
            }
            state.getCandidates().addAll(candidates);
        }
    }

    private List<String> candidates(String start) {
        LinkedList<String> result = new LinkedList<String>();
        for (GitIgnoreTemplateGroup group : ((GitIgnoreFacet)this.project.getFacet(GitIgnoreFacet.class)).list()) {
            for (String template : group.getTemplates()) {
                if (!Strings.isNullOrEmpty((String)start) && !template.startsWith(start)) continue;
                result.add(template);
            }
        }
        return result;
    }
}

