/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git.gitignore;

import java.io.IOException;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.forge.git.GitFacet;
import org.jboss.forge.git.gitignore.GitIgnoreConfig;
import org.jboss.forge.git.gitignore.GitIgnoreFacet;
import org.jboss.forge.git.gitignore.GitIgnoreResource;
import org.jboss.forge.git.gitignore.GitIgnoreTemplateGroup;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.events.PickupResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;

@Alias(value="gitignore")
@Help(value="Creates .gitignore files based on template files from https://github.com/github/gitignore.git.")
@RequiresProject
@RequiresFacet(value={GitFacet.class, GitIgnoreFacet.class})
public class GitIgnore
implements Plugin {
    @Inject
    private GitIgnoreConfig config;
    @Inject
    private Shell shell;
    @Inject
    private ShellPrompt prompt;
    @Inject
    private ResourceFactory factory;
    @Inject
    private Event<InstallFacets> request;
    @Inject
    private Event<PickupResource> pickUp;
    @Inject
    private Project project;

    @SetupCommand(help="Clones the .gitignore template repository into a local destination.")
    public void setup() {
        try {
            this.promptCloneDir();
            this.promptRepository();
            this.request.fire((Object)new InstallFacets(GitIgnoreFacet.class));
        }
        catch (Exception e) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Failed to create gitignore repository: " + e.getMessage()));
        }
    }

    @Command(value="list-templates", help="List all available .gitignore templates")
    public void list(PipeOut out) {
        ShellMessages.info((ShellPrintWriter)this.shell, (String)"Installed .gitignore templates:");
        for (GitIgnoreTemplateGroup group : ((GitIgnoreFacet)this.project.getFacet(GitIgnoreFacet.class)).list()) {
            out.println("============= " + group.getName() + " =============");
            for (String template : group.getTemplates()) {
                out.println(template);
            }
        }
    }

    @Command(value="create", help="Create a .gitignore from templates")
    public void create(PipeOut out, String ... templates) {
        try {
            GitIgnoreFacet facet = (GitIgnoreFacet)this.project.getFacet(GitIgnoreFacet.class);
            GitIgnoreResource resource = this.gitIgnoreResource();
            StringBuffer buffer = new StringBuffer();
            for (String template : templates) {
                String content = facet.contentOf(template);
                buffer.append(content);
            }
            String content = buffer.toString();
            resource.setContents(content);
            ShellMessages.success((ShellPrintWriter)this.shell, (String)"Wrote to .gitignore. Content:");
            out.println(content);
            this.pickUp.fire((Object)new PickupResource((Resource)resource));
        }
        catch (Exception e) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Failed writing .gitignore: " + e.getMessage()));
        }
    }

    @Command(value="update-repo", help="Update the local template repository")
    public void update() {
        try {
            ((GitIgnoreFacet)this.project.getFacet(GitIgnoreFacet.class)).update();
            ShellMessages.success((ShellPrintWriter)this.shell, (String)"Local gitignore repository updated.");
        }
        catch (IOException e) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Error reading local repository: " + e.getMessage()));
        }
        catch (GitAPIException e) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Error pulling remote repository: " + e.getMessage()));
        }
    }

    @Command(value="edit", help="Change the .gitignore file")
    public void edit() {
        this.pickUp.fire((Object)new PickupResource((Resource)this.gitIgnoreResource()));
    }

    private void promptCloneDir() {
        FileResource checkout = this.prompt.promptFile("Where should the gitignore template repository be installed at?", this.defaultDirectory());
        if (checkout.exists()) {
            this.validate(checkout);
        } else {
            checkout.mkdir();
        }
        this.config.setLocalRepository(checkout.getFullyQualifiedName());
    }

    private void promptRepository() {
        String repo = this.prompt.prompt("Do you want to provide a different repository location for gitignore templates?", this.config.defaultRemoteRepository());
        this.config.setRemoteRepository(repo);
    }

    private FileResource<?> defaultDirectory() {
        return (FileResource)this.factory.getResourceFrom(this.config.defaultLocalRepository());
    }

    private void validate(FileResource<?> clone) {
        if (!clone.isDirectory()) {
            throw new IllegalArgumentException("File " + clone + " is not a directory.");
        }
        if (!clone.listResources().isEmpty()) {
            throw new IllegalArgumentException("Directory " + clone + " is not empty");
        }
    }

    private GitIgnoreResource gitIgnoreResource() {
        GitIgnoreResource resource = (GitIgnoreResource)this.project.getProjectRoot().getChildOfType(GitIgnoreResource.class, ".gitignore");
        if (!resource.exists()) {
            resource.createNewFile();
        }
        return resource;
    }
}

