/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jpa;

import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.maven.model.Repository;
import org.jboss.forge.maven.MavenPluginFacet;
import org.jboss.forge.maven.plugins.Configuration;
import org.jboss.forge.maven.plugins.ConfigurationBuilder;
import org.jboss.forge.maven.plugins.ConfigurationElement;
import org.jboss.forge.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.maven.plugins.Execution;
import org.jboss.forge.maven.plugins.ExecutionBuilder;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyFilter;
import org.jboss.forge.project.dependencies.DependencyQuery;
import org.jboss.forge.project.dependencies.DependencyQueryBuilder;
import org.jboss.forge.project.dependencies.NonSnapshotDependencyFilter;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.spec.javaee.PersistenceFacet;
import org.jboss.forge.spec.javaee.PersistenceMetaModelFacet;
import org.jboss.forge.spec.javaee.jpa.api.JPAProvider;
import org.jboss.forge.spec.javaee.jpa.api.MetaModelProvider;
import org.jboss.forge.spec.javaee.jpa.api.PersistenceProvider;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceUnitDef;

@Alias(value="forge.spec.jpa.metamodel")
@RequiresFacet(value={PersistenceFacet.class, MavenPluginFacet.class})
public class PersistenceMetaModelFacetImpl
extends BaseFacet
implements PersistenceMetaModelFacet {
    @Inject
    private BeanManager manager;
    @Inject
    private ShellPrompt prompt;

    public boolean install() {
        MetaModelProvider provider = this.lookupProvider();
        this.addProcessorPlugin(provider);
        this.modifyCompilerPlugin();
        this.addPluginRepository(provider);
        return true;
    }

    public boolean isInstalled() {
        return this.processorConfigured(this.lookupProvider());
    }

    public String getProcessor() {
        return this.lookupProvider().getProcessor();
    }

    public String getCompilerArgs() {
        return this.lookupProvider().getCompilerArguments();
    }

    public Dependency getProcessorDependency() {
        return this.lookupProvider().getAptDependency();
    }

    private MetaModelProvider lookupProvider() {
        PersistenceDescriptor config = ((PersistenceFacet)this.project.getFacet(PersistenceFacet.class)).getConfig();
        String providerName = config.listUnits().size() > 0 ? ((PersistenceUnitDef)config.listUnits().get(0)).getProvider() : null;
        for (JPAProvider jpaProvider : JPAProvider.values()) {
            PersistenceProvider candidate = jpaProvider.getProvider(this.manager);
            if (!candidate.getProvider().equals(providerName)) continue;
            return candidate.getMetaModelProvider();
        }
        return JPAProvider.HIBERNATE.getProvider(this.manager).getMetaModelProvider();
    }

    private void addProcessorPlugin(MetaModelProvider provider) {
        DependencyBuilder processorDependency = this.createProcessorDependency();
        Dependency versioned = this.promptVersion((Dependency)processorDependency);
        ConfigurationBuilder configuration = ConfigurationBuilder.create();
        configuration.createConfigurationElement("processors").addChild("processor").setText(provider.getProcessor());
        if (!Strings.isNullOrEmpty((String)provider.getCompilerArguments())) {
            configuration.createConfigurationElement("compilerArguments").setText(provider.getCompilerArguments());
        }
        ExecutionBuilder execution = ExecutionBuilder.create().setId("process").setPhase("generate-sources").addGoal("process").setConfig((Configuration)configuration);
        Dependency aptDependency = provider.getAptDependency();
        if (Strings.isNullOrEmpty((String)aptDependency.getVersion())) {
            aptDependency = this.promptVersion(aptDependency);
        }
        MavenPluginBuilder processorPlugin = MavenPluginBuilder.create().setDependency(versioned).addExecution((Execution)execution).addPluginDependency(aptDependency);
        ((MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class)).addPlugin((MavenPlugin)processorPlugin);
        ((DependencyFacet)this.project.getFacet(DependencyFacet.class)).addDirectDependency((Dependency)DependencyBuilder.create((Dependency)aptDependency).setScopeType("provided"));
    }

    private DependencyBuilder createProcessorDependency() {
        DependencyBuilder processorDependency = DependencyBuilder.create().setGroupId("org.bsc.maven").setArtifactId("maven-processor-plugin");
        return processorDependency;
    }

    private void modifyCompilerPlugin() {
        DependencyBuilder compilerDependency = DependencyBuilder.create().setGroupId("org.apache.maven.plugins").setArtifactId("maven-compiler-plugin");
        MavenPluginFacet pluginFacet = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
        MavenPlugin compiler = pluginFacet.getPlugin((Dependency)compilerDependency);
        Configuration config = compiler.getConfig();
        if (!config.hasConfigurationElement("proc")) {
            ConfigurationElementBuilder proc = ConfigurationBuilder.create().createConfigurationElement("proc").setText("none");
            config.addConfigurationElement((ConfigurationElement)proc);
        }
        pluginFacet.updatePlugin(compiler);
    }

    private boolean processorConfigured(MetaModelProvider provider) {
        Configuration config;
        MavenPlugin plugin;
        DependencyBuilder dependency = this.createProcessorDependency().setVersion(null);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
        if (pluginFacet.hasPlugin((Dependency)dependency) && (plugin = pluginFacet.getPlugin((Dependency)dependency)).listExecutions().size() > 0 && (config = ((Execution)plugin.listExecutions().get(0)).getConfig()).hasConfigurationElement("processors")) {
            ConfigurationElement element = config.getConfigurationElement("processors").getChildByName("processor");
            return element.getText().equals(provider.getProcessor());
        }
        return false;
    }

    private void addPluginRepository(MetaModelProvider provider) {
        Repository repository = provider.getAptPluginRepository();
        if (repository != null) {
            MavenPluginFacet pluginFacet = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
            pluginFacet.addPluginRepository(repository.getName(), repository.getUrl());
        }
    }

    private Dependency promptVersion(Dependency dependency) {
        DependencyFacet dependencyFacet = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        Dependency result = dependency;
        List versions = dependencyFacet.resolveAvailableVersions((DependencyQuery)DependencyQueryBuilder.create((Dependency)dependency).setFilter((DependencyFilter)new NonSnapshotDependencyFilter()));
        if (versions.size() > 0) {
            Dependency deflt = (Dependency)versions.get(versions.size() - 1);
            result = (Dependency)this.prompt.promptChoiceTyped("Use which version of '" + dependency.getArtifactId() + "' ?", versions, (Object)deflt);
        }
        return result;
    }
}

