/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.resources.java.JavaResourceVisitor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.spec.javaee.RestApplicationFacet;

@Alias(value="forge.spec.jaxrs.applicationclass")
@RequiresFacet(value={JavaSourceFacet.class})
public class RestApplicationFacetImpl
extends BaseFacet
implements RestApplicationFacet {
    private String classPackage;
    private String className;
    private String rootPath;
    @Inject
    private Configuration configuration;

    @Inject
    public RestApplicationFacetImpl(Configuration configuration) {
        this.classPackage = configuration.getString("rest.applicationclass.package");
        this.className = configuration.getString("rest.applicationclass.name");
        this.rootPath = configuration.getString("rootpath");
    }

    public boolean install() {
        if (!this.isInstalled()) {
            JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
            JavaClass applicationClass = (JavaClass)((JavaClass)((JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setPackage(this.classPackage)).setName(this.className)).setSuperType("javax.ws.rs.core.Application")).addAnnotation("javax.ws.rs.ApplicationPath").setStringValue(this.rootPath).getOrigin();
            applicationClass.addImport("javax.ws.rs.core.Application");
            applicationClass.addImport("javax.ws.rs.ApplicationPath");
            try {
                javaSourceFacet.saveJavaSource((JavaSource)applicationClass);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public boolean isInstalled() {
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        if (!(this.classPackage != null && this.className != null || this.findApplicationClass())) {
            return false;
        }
        try {
            JavaResource javaResource = javaSourceFacet.getJavaResource(this.classPackage + "." + this.className);
            if (javaResource.exists() || this.findApplicationClass()) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return false;
    }

    private boolean findApplicationClass() {
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        this.configuration.clearProperty("rest.applicationclass.name");
        this.configuration.clearProperty("rest.applicationclass.package");
        javaSourceFacet.visitJavaSources(new JavaResourceVisitor(){
            boolean found = false;

            public void visit(JavaResource javaResource) {
                if (!this.found) {
                    try {
                        if (javaResource.getJavaSource().getAnnotation("javax.ws.rs.ApplicationPath") != null) {
                            RestApplicationFacetImpl.this.configuration.setProperty("rest.applicationclass.package", (Object)javaResource.getJavaSource().getPackage());
                            RestApplicationFacetImpl.this.configuration.setProperty("rest.applicationclass.name", (Object)javaResource.getFullyQualifiedName());
                            RestApplicationFacetImpl.this.configuration.setProperty("rootpath", (Object)javaResource.getJavaSource().getAnnotation("javax.ws.rs.ApplicationPath").getLiteralValue());
                            this.found = true;
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return this.configuration.getString("rest.applicationclass.name") != null;
    }

    public void setApplicationPath(String path) {
        this.configuration.setProperty("rootpath", (Object)path);
        if (this.classPackage == null || this.className == null) {
            this.reportConfigurationError(this.className);
        }
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        try {
            String classname = this.classPackage + "." + this.className;
            JavaResource javaResource = javaSourceFacet.getJavaResource(classname);
            if (!javaResource.exists()) {
                this.reportConfigurationError(classname);
            }
            javaResource.getJavaSource().getAnnotation("javax.ws.rs.ApplicationPath").setStringValue(path);
        }
        catch (FileNotFoundException e) {
            this.reportConfigurationError(this.className);
        }
    }

    private void reportConfigurationError(String classname) {
        throw new RuntimeException("Error setting application path. The class '" + classname + "' in your configuration file does not exist. Run rest setup again.");
    }
}

